/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.javabuilder;

import com.github.leeonky.javabuilder.TriFunction;
import com.github.leeonky.javabuilder.TypeOperator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class PropertyBuilder {
    public static final LocalDate LOCAL_DATE_START = LocalDate.parse("1996-01-23");
    public static final LocalDateTime LOCAL_DATE_TIME_START = LocalDateTime.parse("1996-01-23T00:00:00");
    private static final LocalTime LOCAL_TIME_START = LocalTime.parse("00:00:00");
    private static final Instant INSTANT_START = Instant.parse("1996-01-23T00:00:00Z");
    private List<TypeOperator<TriFunction>> setters = new ArrayList<TypeOperator<TriFunction>>();
    private Map<Predicate<Method>, TriFunction<Method, Object, Integer, Object>> methodBuilders = new LinkedHashMap<Predicate<Method>, TriFunction<Method, Object, Integer, Object>>();
    private List<Predicate<Method>> skipper = new ArrayList<Predicate<Method>>();

    public static PropertyBuilder createDefaultPropertyBuilder() {
        return new PropertyBuilder().addPropertyBuilder(String.class, (c, p, i) -> p + i).addPropertyBuilder(Long.TYPE, (c, p, i) -> (long)i).addPropertyBuilder(Integer.TYPE, (c, p, i) -> i).addPropertyBuilder(Short.TYPE, (c, p, i) -> (short)i.intValue()).addPropertyBuilder(Byte.TYPE, (c, p, i) -> (byte)i.intValue()).addPropertyBuilder(Double.TYPE, (c, p, i) -> (double)i).addPropertyBuilder(Float.TYPE, (c, p, i) -> Float.valueOf(i.intValue())).addPropertyBuilder(Boolean.TYPE, (c, p, i) -> i % 2 != 0).addPropertyBuilder(Long.class, (c, p, i) -> (long)i).addPropertyBuilder(Integer.class, (c, p, i) -> i).addPropertyBuilder(Short.class, (c, p, i) -> (short)i.intValue()).addPropertyBuilder(Byte.class, (c, p, i) -> (byte)i.intValue()).addPropertyBuilder(Double.class, (c, p, i) -> (double)i).addPropertyBuilder(Float.class, (c, p, i) -> Float.valueOf(i.intValue())).addPropertyBuilder(Boolean.class, (c, p, i) -> i % 2 != 0).addPropertyBuilder(BigInteger.class, (c, p, i) -> BigInteger.valueOf(i.intValue())).addPropertyBuilder(BigDecimal.class, (c, p, i) -> BigDecimal.valueOf(i.intValue())).addPropertyBuilder(UUID.class, (c, p, i) -> UUID.fromString(String.format("00000000-0000-0000-0000-%012d", i))).addPropertyBuilder(Instant.class, (c, p, i) -> INSTANT_START.plusSeconds(i.intValue())).addPropertyBuilder(Date.class, (c, p, i) -> Date.from(INSTANT_START.plus((long)(i - 1), ChronoUnit.DAYS))).addPropertyBuilder(LocalTime.class, (c, p, i) -> LOCAL_TIME_START.plusSeconds(i.intValue())).addPropertyBuilder(LocalDate.class, (c, p, i) -> LOCAL_DATE_START.plusDays(i - 1)).addPropertyBuilder(LocalDateTime.class, (c, p, i) -> LOCAL_DATE_TIME_START.plusSeconds(i.intValue())).addPropertyBuilder(Enum.class, (c, p, i) -> {
            Enum[] enums = (Enum[])c.getEnumConstants();
            return enums[(i - 1) % enums.length];
        });
    }

    public <T> PropertyBuilder addPropertyBuilder(Class<T> type, TriFunction<Class<T>, String, Integer, T> builder) {
        this.setters.add(new TypeOperator<TriFunction<Class<T>, String, Integer, T>>(type, builder));
        return this;
    }

    public PropertyBuilder addMethodBuilder(Predicate<Method> predicate, TriFunction<Method, Object, Integer, Object> builder) {
        this.methodBuilders.put(predicate, builder);
        return this;
    }

    public PropertyBuilder addSkipMethod(Predicate<Method> predicate) {
        this.skipper.add(predicate);
        return this;
    }

    public <T> T apply(int sequence, T object) {
        Stream.of(object.getClass().getMethods()).filter(this::isSetter).filter(method -> !this.skipper.stream().anyMatch(p -> p.test(method))).forEach(m -> this.buildAndAssign((Method)m, sequence, object));
        return object;
    }

    private boolean isSetter(Method m) {
        return m.getName().startsWith("set") && m.getParameterTypes().length == 1;
    }

    private <T> void buildAndAssign(Method method, int sequence, T object) {
        Stream.concat(this.buildValueFromMethodBuilder(method, sequence, object), this.buildValueFromPropertyBuilder(method, sequence)).findFirst().ifPresent(value -> {
            try {
                method.invoke(object, value);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        });
    }

    private <T> Stream<Object> buildValueFromMethodBuilder(Method method, int sequence, T object) {
        return this.methodBuilders.entrySet().stream().filter(e -> ((Predicate)e.getKey()).test(method)).map(e -> ((TriFunction)e.getValue()).apply(method, object, sequence));
    }

    private Stream<Object> buildValueFromPropertyBuilder(Method method, int sequence) {
        return Stream.concat(this.setters.stream().filter(s -> s.isPreciseType(method.getParameterTypes()[0])), this.setters.stream().filter(s -> s.isBaseType(method.getParameterTypes()[0]))).map(t -> ((TriFunction)t.getConverter()).apply(method.getParameterTypes()[0], this.toPropertyName(method), sequence));
    }

    private String toPropertyName(Method method) {
        return StringUtils.uncapitalize((String)method.getName().replaceFirst("^set", ""));
    }
}

