/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.javabuilder;

import com.github.leeonky.javabuilder.Converter;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class BeanUtil {
    private final Converter converter = Converter.createDefaultConverter();

    public Converter getConverter() {
        return this.converter;
    }

    public <T> T assignProperties(T object, Map<String, ?> properties) {
        properties.entrySet().stream().filter(e -> e.getValue() != null).forEach(e -> this.assignProperty(object, (Map.Entry<String, ?>)e));
        return object;
    }

    private void assignProperty(Object object, Map.Entry<String, ?> e) {
        Method method = this.getMethod(object, e.getKey());
        Class<?> valueType = method.getParameterTypes()[0];
        Object value = e.getValue();
        try {
            method.invoke(object, this.converter.tryConvert(valueType, value));
        }
        catch (Exception ex) {
            throw new IllegalStateException(String.format("Got exception in '%s::%s(%s)', value is %s[%s]", object.getClass().getName(), method.getName(), valueType.getName(), value.getClass().getName(), value), ex);
        }
    }

    private Method getMethod(Object object, String propertyName) {
        return Stream.of(object.getClass().getMethods()).filter(this.isSetter(propertyName)).findFirst().orElseThrow(() -> new IllegalStateException(String.format("No setter was found in '%s' for property '%s'", object.getClass().getName(), propertyName)));
    }

    private Predicate<Method> isSetter(String propertyName) {
        return m -> m.getName().equals("set" + StringUtils.capitalize((String)propertyName)) && m.getParameterTypes().length == 1;
    }
}

