/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.javabuilder;

import com.github.leeonky.javabuilder.BeanContext;
import com.github.leeonky.javabuilder.BeanFactory;
import com.github.leeonky.javabuilder.BeanSpecs;
import com.github.leeonky.javabuilder.BeanSpecsFactory;
import com.github.leeonky.javabuilder.BeanWithNoDefaultConstructorFactory;
import com.github.leeonky.javabuilder.Builder;
import com.github.leeonky.javabuilder.DataRepository;
import com.github.leeonky.javabuilder.DefaultBeanFactory;
import com.github.leeonky.javabuilder.Factory;
import com.github.leeonky.javabuilder.HashMapDataRepository;
import com.github.leeonky.javabuilder.PropertyBuilder;
import com.github.leeonky.util.BeanClass;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class FactorySet {
    private final PropertyBuilder propertyBuilder = PropertyBuilder.createDefaultPropertyBuilder();
    private final Map<Class<?>, Factory<?>> factories = new HashMap();
    private final Map<Class<?>, Factory<?>> beanSpecsMap = new HashMap();
    private final Map<String, Factory<?>> beanSpecsNameMap = new HashMap();
    private final Map<Class<?>, Integer> sequences = new HashMap();
    private final DataRepository dataRepository;

    public FactorySet() {
        this.dataRepository = new HashMapDataRepository();
    }

    public FactorySet(DataRepository dataRepository) {
        this.dataRepository = dataRepository;
    }

    public PropertyBuilder getPropertyBuilder() {
        return this.propertyBuilder;
    }

    public <T> Factory<T> onBuild(Class<T> type, Consumer<T> build) {
        return this.onBuild(type, (T o, BeanContext<T> context) -> build.accept(o));
    }

    public <T> Factory<T> onBuild(Class<T> type, BiConsumer<T, BeanContext<T>> build) {
        try {
            type.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("No default constructor of class: " + type.getName());
        }
        BeanFactory<T> beanFactory = new BeanFactory<T>(type, build);
        this.factories.put(type, beanFactory);
        return beanFactory;
    }

    public <T> Factory<T> register(Class<T> type, Supplier<T> supplier) {
        BeanWithNoDefaultConstructorFactory<Object> factory = new BeanWithNoDefaultConstructorFactory<Object>(type, buildContext -> supplier.get());
        this.factories.put(type, factory);
        return factory;
    }

    public <T> Factory<T> register(Class<T> type, Function<BeanContext<T>, T> supplier) {
        BeanWithNoDefaultConstructorFactory<T> factory = new BeanWithNoDefaultConstructorFactory<T>(type, supplier);
        this.factories.put(type, factory);
        return factory;
    }

    public <B extends BeanSpecs<T>, T> FactorySet define(Class<B> beanSpecificationClass) {
        BeanSpecs beanDefinition = (BeanSpecs)BeanClass.newInstance(beanSpecificationClass, (Object[])new Object[0]);
        if (this.beanSpecsNameMap.containsKey(beanDefinition.getName())) {
            throw new IllegalArgumentException(String.format("Specification '%s' already exists", beanDefinition.getName()));
        }
        BeanSpecsFactory beanSpecsFactory = new BeanSpecsFactory(beanDefinition);
        this.beanSpecsMap.put(beanSpecificationClass, beanSpecsFactory);
        this.beanSpecsNameMap.put(beanDefinition.getName(), beanSpecsFactory);
        return this;
    }

    public <T> Factory<T> factory(Class<T> type) {
        return this.factories.computeIfAbsent(type, k -> new DefaultBeanFactory(type));
    }

    public <T> Builder<T> type(Class<T> type) {
        return new Builder<T>(this.factory(type), this);
    }

    public <B extends BeanSpecs<T>, T> Builder<T> toBuild(Class<B> beanSpecsClass) {
        Factory<?> factory = this.beanSpecsMap.get(beanSpecsClass);
        if (null == factory) {
            return this.define(beanSpecsClass).toBuild(beanSpecsClass);
        }
        return new Builder(factory, this);
    }

    public <T> Builder<T> toBuild(String beanSpecsName) {
        Factory<?> factory = this.beanSpecsNameMap.get(beanSpecsName);
        if (null == factory) {
            throw new IllegalArgumentException(String.format("Specification '%s' not exists", beanSpecsName));
        }
        return new Builder(factory, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getSequence(Class<?> type) {
        Class<FactorySet> clazz = FactorySet.class;
        synchronized (FactorySet.class) {
            int sequence = this.sequences.getOrDefault(type, 0) + 1;
            this.sequences.put(type, sequence);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return sequence;
        }
    }

    public DataRepository getDataRepository() {
        return this.dataRepository;
    }
}

