/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.javabuilder;

import com.github.leeonky.javabuilder.BeanContext;
import com.github.leeonky.javabuilder.TriFunction;
import com.github.leeonky.javabuilder.TypeHandler;
import com.github.leeonky.util.PropertyWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class PropertyBuilder {
    public static final LocalDate LOCAL_DATE_START = LocalDate.parse("1996-01-23");
    public static final LocalDateTime LOCAL_DATE_TIME_START = LocalDateTime.parse("1996-01-23T00:00:00");
    private static final LocalTime LOCAL_TIME_START = LocalTime.parse("00:00:00");
    private static final Instant INSTANT_START = Instant.parse("1996-01-23T00:00:00Z");
    private List<TypeHandler<TriFunction>> setters = new ArrayList<TypeHandler<TriFunction>>();
    private List<Predicate> skipper = new ArrayList<Predicate>();
    private Map<Predicate, TriFunction> propertyBuilders = new LinkedHashMap<Predicate, TriFunction>();

    public static PropertyBuilder createDefaultPropertyBuilder() {
        return new PropertyBuilder().registerThroughType(String.class, (c, p, buildingContext) -> p.getName() + buildingContext.getCurrentSequence()).registerThroughType(Long.TYPE, (c, p, buildingContext) -> buildingContext.getCurrentSequence()).registerThroughType(Integer.TYPE, (c, p, buildingContext) -> buildingContext.getCurrentSequence()).registerThroughType(Short.TYPE, (c, p, buildingContext) -> (short)buildingContext.getCurrentSequence()).registerThroughType(Byte.TYPE, (c, p, buildingContext) -> (byte)buildingContext.getCurrentSequence()).registerThroughType(Double.TYPE, (c, p, buildingContext) -> buildingContext.getCurrentSequence()).registerThroughType(Float.TYPE, (c, p, buildingContext) -> Float.valueOf(buildingContext.getCurrentSequence())).registerThroughType(Boolean.TYPE, (c, p, buildingContext) -> buildingContext.getCurrentSequence() % 2 != 0).registerThroughType(Long.class, (c, p, buildingContext) -> buildingContext.getCurrentSequence()).registerThroughType(Integer.class, (c, p, buildingContext) -> buildingContext.getCurrentSequence()).registerThroughType(Short.class, (c, p, buildingContext) -> (short)buildingContext.getCurrentSequence()).registerThroughType(Byte.class, (c, p, buildingContext) -> (byte)buildingContext.getCurrentSequence()).registerThroughType(Double.class, (c, p, buildingContext) -> buildingContext.getCurrentSequence()).registerThroughType(Float.class, (c, p, buildingContext) -> Float.valueOf(buildingContext.getCurrentSequence())).registerThroughType(Boolean.class, (c, p, buildingContext) -> buildingContext.getCurrentSequence() % 2 != 0).registerThroughType(BigInteger.class, (c, p, buildingContext) -> BigInteger.valueOf(buildingContext.getCurrentSequence())).registerThroughType(BigDecimal.class, (c, p, buildingContext) -> BigDecimal.valueOf(buildingContext.getCurrentSequence())).registerThroughType(UUID.class, (c, p, buildingContext) -> UUID.fromString(String.format("00000000-0000-0000-0000-%012d", buildingContext.getCurrentSequence()))).registerThroughType(Instant.class, (c, p, buildingContext) -> INSTANT_START.plusSeconds(buildingContext.getCurrentSequence())).registerThroughType(Date.class, (c, p, buildingContext) -> Date.from(INSTANT_START.plus((long)buildingContext.getCurrentSequence(), ChronoUnit.DAYS))).registerThroughType(LocalTime.class, (c, p, buildingContext) -> LOCAL_TIME_START.plusSeconds(buildingContext.getCurrentSequence())).registerThroughType(LocalDate.class, (c, p, buildingContext) -> LOCAL_DATE_START.plusDays(buildingContext.getCurrentSequence())).registerThroughType(LocalDateTime.class, (c, p, buildingContext) -> LOCAL_DATE_TIME_START.plusSeconds(buildingContext.getCurrentSequence())).registerThroughType(OffsetDateTime.class, (c, p, buildingContext) -> INSTANT_START.plusSeconds(buildingContext.getCurrentSequence()).atZone(ZoneId.systemDefault()).toOffsetDateTime()).registerThroughType(ZonedDateTime.class, (c, p, buildingContext) -> INSTANT_START.plusSeconds(buildingContext.getCurrentSequence()).atZone(ZoneId.systemDefault())).registerThroughType(Enum.class, (c, p, buildingContext) -> {
            Enum[] enums = (Enum[])c.getEnumConstants();
            return enums[(buildingContext.getCurrentSequence() - 1) % enums.length];
        });
    }

    public <T, B> PropertyBuilder registerThroughType(Class<T> propertyType, TriFunction<Class<T>, PropertyWriter<B>, BeanContext<B>, T> builder) {
        this.setters.add(new TypeHandler<TriFunction<Class<T>, PropertyWriter<B>, BeanContext<B>, T>>(propertyType, builder));
        return this;
    }

    public <B> PropertyBuilder registerThroughProperty(Predicate<PropertyWriter<B>> predicate, TriFunction<PropertyWriter<B>, Object, BeanContext<B>, Object> builder) {
        this.propertyBuilders.put(predicate, builder);
        return this;
    }

    public PropertyBuilder skipProperty(Predicate<PropertyWriter<?>> predicate) {
        this.skipper.add(predicate);
        return this;
    }

    public <T> void assignDefaultValueToProperties(T object, BeanContext<T> beanContext) {
        beanContext.getBeanClass().getPropertyWriters().values().stream().filter(propertyWriter -> this.skipper.stream().noneMatch(p -> p.test(propertyWriter))).filter(propertyWriter -> beanContext.isPropertyNotSpecified(propertyWriter.getName())).forEach(propertyWriter -> this.assignDefaultValueToProperty(object, (PropertyWriter)propertyWriter, beanContext));
    }

    private void assignDefaultValueToProperty(Object object, PropertyWriter propertyWriter, BeanContext<?> beanContext) {
        Stream.concat(this.buildValueFromMethodBuilder(propertyWriter, object, beanContext), this.buildValueFromPropertyBuilder(propertyWriter, beanContext)).findFirst().ifPresent(value -> propertyWriter.setValue(object, value));
    }

    private Stream<Object> buildValueFromMethodBuilder(PropertyWriter propertyWriter, Object object, BeanContext<?> beanContext) {
        return this.propertyBuilders.entrySet().stream().filter(e -> ((Predicate)e.getKey()).test(propertyWriter)).map(e -> ((TriFunction)e.getValue()).apply(propertyWriter, object, beanContext));
    }

    private Stream<Object> buildValueFromPropertyBuilder(PropertyWriter propertyWriter, BeanContext<?> beanContext) {
        return Stream.concat(this.setters.stream().filter(s -> s.isPreciseType(propertyWriter.getPropertyType())), this.setters.stream().filter(s -> s.isBaseType(propertyWriter.getPropertyType()))).map(t -> ((TriFunction)t.getHandler()).apply(propertyWriter.getPropertyType(), propertyWriter, beanContext));
    }
}

