/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.javabuilder;

import com.github.leeonky.util.BeanClass;
import java.util.LinkedList;
import java.util.List;

class PropertyChain {
    private final List<String> names;

    PropertyChain(List<String> names) {
        this.names = names;
    }

    void setTo(Object object, Object property) {
        this.setTo(new LinkedList<String>(this.names), object, property);
    }

    Object getFrom(Object object) {
        return this.getFrom(new LinkedList<String>(this.names), object);
    }

    private void setTo(LinkedList<String> properties, Object object, Object property) {
        String targetPropertyName = properties.removeLast();
        Object targetObject = this.getFrom(properties, object);
        BeanClass.create(targetObject.getClass()).setPropertyValue(targetObject, targetPropertyName, property);
    }

    private Object getFrom(LinkedList<String> properties, Object object) {
        if (properties.isEmpty()) {
            return object;
        }
        String firstProperty = properties.removeFirst();
        return this.getFrom(properties, BeanClass.create(object.getClass()).getPropertyValue(object, firstProperty));
    }

    public int hashCode() {
        return this.names.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PropertyChain) {
            return this.names.equals(((PropertyChain)obj).names);
        }
        return super.equals(obj);
    }
}

