/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.javabuilder;

import com.github.leeonky.javabuilder.BeanContext;
import com.github.leeonky.javabuilder.BuildingContext;
import com.github.leeonky.javabuilder.Factory;
import com.github.leeonky.javabuilder.FactorySet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class Builder<T> {
    private final Factory<T> factory;
    private final FactorySet factorySet;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Map<String, Object> params = new HashMap<String, Object>();
    private String[] combinations = new String[0];
    private Consumer<BeanContext<T>> spec = beanContext -> {};

    Builder(Factory<T> factory, FactorySet factorySet) {
        this.factory = factory;
        this.factorySet = factorySet;
    }

    private Builder<T> copy() {
        Builder<T> newBuilder = new Builder<T>(this.factory, this.factorySet);
        newBuilder.properties.putAll(this.properties);
        newBuilder.params.putAll(this.params);
        newBuilder.combinations = Arrays.copyOf(this.combinations, this.combinations.length);
        newBuilder.spec = this.spec;
        return newBuilder;
    }

    public Builder<T> property(String property, Object value) {
        Builder<T> builder = this.copy();
        builder.properties.put(property, value);
        return builder;
    }

    public Builder<T> properties(Map<String, ?> properties) {
        Builder<T> builder = this.copy();
        builder.properties.putAll(properties);
        return builder;
    }

    public Stream<Builder<T>> properties(Collection<Map<String, ?>> properties) {
        return properties.stream().map(this::properties);
    }

    public Builder<T> param(String paramName, Object value) {
        Builder<T> builder = this.copy();
        builder.params.put(paramName, value);
        return builder;
    }

    public Builder<T> spec(Consumer<BeanContext<T>> spec) {
        Builder<T> builder = this.copy();
        builder.spec = Objects.requireNonNull(spec);
        return builder;
    }

    public List<T> query() {
        return this.factorySet.getDataRepository().query(this.factory.getBeanClass(), this.properties);
    }

    public Builder<T> combine(String ... combinations) {
        Builder<T> builder = this.copy();
        builder.combinations = Objects.requireNonNull(combinations);
        return builder;
    }

    public T create() {
        BuildingContext buildingContext = new BuildingContext(this.factorySet);
        T object = this.build(buildingContext);
        buildingContext.applyAllSpecs(object);
        return this.factorySet.getDataRepository().save(object);
    }

    T build(BuildingContext buildingContext) {
        BeanContext<T> beanContext = buildingContext.createBeanContext(this.factory, this.params, this.properties, this.spec, this.combinations);
        beanContext.queryOrCreateReferenceBeansAndCollectAllSpecs();
        return this.build(beanContext);
    }

    private T build(BeanContext<T> beanContext) {
        return beanContext.assignProperties(this.factory.newInstance(beanContext));
    }

    BeanContext<T> createSubBeanContext(BeanContext<?> parent, String propertyName) {
        return parent.createSubContext(this.factory, propertyName, this.factorySet.getSequence(this.factory.getBeanClass().getType()), this.params, this.properties, this.spec, this.combinations);
    }

    T subCreate(BeanContext<T> subContext) {
        T object = this.build(subContext);
        this.factorySet.getDataRepository().save(object);
        return object;
    }
}

