/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.javabuilder;

import com.github.leeonky.javabuilder.BeanSpecs;
import com.github.leeonky.javabuilder.Builder;
import com.github.leeonky.javabuilder.BuildingContext;
import com.github.leeonky.javabuilder.DependencySpec;
import com.github.leeonky.javabuilder.Factory;
import com.github.leeonky.javabuilder.FactorySet;
import com.github.leeonky.javabuilder.PropertyChain;
import com.github.leeonky.javabuilder.PropertyQueryChain;
import com.github.leeonky.javabuilder.PropertySpec;
import com.github.leeonky.javabuilder.SupplierSpec;
import com.github.leeonky.util.BeanClass;
import com.github.leeonky.util.PropertyWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class BeanContext<T> {
    private final Factory<T> factory;
    private final FactorySet factorySet;
    private final int sequence;
    private final Map<String, Object> params;
    private final Map<String, Object> specifiedProperties = new LinkedHashMap<String, Object>();
    private final Map<String, Object> originalProperties;
    private final Consumer<BeanContext<T>> spec;
    private final String[] combinations;
    private final BuildingContext buildingContext;
    private final BeanContext<?> parent;
    private final String currentPropertyName;
    private final Set<String> propertyNames = new HashSet<String>();
    private T built;

    BeanContext(FactorySet factorySet, Factory<T> factory, BeanContext<?> parent, String propertyNameInParent, int sequence, Map<String, Object> params, Map<String, Object> properties, BuildingContext buildingContext, Consumer<BeanContext<T>> spec, String[] combinations) {
        this.sequence = sequence;
        this.params = new LinkedHashMap<String, Object>(params);
        this.factory = factory;
        this.factorySet = factorySet;
        this.buildingContext = buildingContext;
        this.parent = parent;
        this.currentPropertyName = propertyNameInParent;
        this.spec = spec;
        this.combinations = combinations;
        this.originalProperties = new LinkedHashMap<String, Object>(properties);
    }

    void queryOrCreateReferenceBeansAndCollectAllSpecs() {
        this.originalProperties.forEach((k, v) -> {
            if (k.contains(".")) {
                PropertyQueryChain propertyQueryChain = PropertyQueryChain.parse(k);
                PropertyWriter propertyWriter = this.factory.getBeanClass().getPropertyWriter(propertyQueryChain.getBaseName());
                Builder<?> builder = propertyQueryChain.toBuilder(this.factorySet, propertyWriter.getPropertyType(), v);
                Optional queried = builder.query().stream().findFirst();
                queried.ifPresent(o -> this.specifiedProperties.put(propertyWriter.getName(), o));
                if (!queried.isPresent()) {
                    BeanContext<?> subBeanContext = builder.createSubBeanContext(this, propertyWriter.getName());
                    PropertyChain propertyChain = new PropertyChain(this.absolutePropertyChain(propertyWriter.getName()));
                    this.buildingContext.appendPropertiesSpec(propertyChain, new PropertySpec(propertyWriter.getPropertyType(), propertyChain, () -> builder.subCreate(subBeanContext), (String)k, v));
                    subBeanContext.queryOrCreateReferenceBeansAndCollectAllSpecs();
                    this.propertyNames.add(propertyWriter.getName());
                }
            } else {
                this.specifiedProperties.put((String)k, v);
            }
        });
        this.factory.collectSpecs(this, this.combinations);
        this.collectSpecs(this.spec);
    }

    public int getCurrentSequence() {
        return this.sequence;
    }

    public <P> P param(String name) {
        return (P)this.params.get(name);
    }

    public BeanClass<T> getBeanClass() {
        return this.factory.getBeanClass();
    }

    public boolean isPropertyNotSpecified(String name) {
        return !this.specifiedProperties.containsKey(name) && !this.propertyNames.contains(name);
    }

    void assignDefaultValueToUnSpecifiedProperties(T object) {
        this.factorySet.getPropertyBuilder().assignDefaultValueToProperties(object, this);
    }

    public FactorySet getFactorySet() {
        return this.factorySet;
    }

    T assignProperties(T instance) {
        this.specifiedProperties.forEach((k, v) -> this.factory.getBeanClass().setPropertyValue(instance, k, v));
        this.built = instance;
        return instance;
    }

    void collectSpecs(Consumer<BeanContext<T>> spec) {
        spec.accept(this);
    }

    <T> BeanContext<T> createSubContext(Factory<T> factory, String propertyName, int sequence, Map<String, Object> params, Map<String, Object> properties, Consumer<BeanContext<T>> spec, String[] combinations) {
        return new BeanContext<T>(this.factorySet, factory, this, propertyName, sequence, params, properties, this.buildingContext, spec, combinations);
    }

    private List<String> absolutePropertyChain(String property) {
        return this.absolutePropertyChain(this.parent, property);
    }

    private List<String> absolutePropertyChain(BeanContext<?> parent, String property) {
        ArrayList<String> chain = parent == null ? new ArrayList<String>() : super.absolutePropertyChain(parent.parent, this.currentPropertyName);
        chain.add(property);
        return chain;
    }

    BuildingContext getBuildingContext() {
        return this.buildingContext;
    }

    public PropertySpecBuilder property(String property) {
        return new PropertySpecBuilder(property);
    }

    public void cacheSave(T object) {
        this.buildingContext.cacheSave(this.parent.built, object);
    }

    public class PropertySpecBuilder {
        private final String property;

        PropertySpecBuilder(String property) {
            this.property = property;
        }

        public BeanContext<T> value(Object value) {
            return this.from(() -> value);
        }

        public BeanContext<T> from(Supplier<?> supplier) {
            if (BeanContext.this.isPropertyNotSpecified(this.property)) {
                PropertyChain propertyChain = new PropertyChain(BeanContext.this.absolutePropertyChain(this.property));
                BeanContext.this.buildingContext.appendSupplierSpec(propertyChain, new SupplierSpec(propertyChain, supplier));
            }
            return BeanContext.this;
        }

        public <PT> BeanContext<T> from(Class<? extends BeanSpecs<PT>> beanSpecsClass) {
            return this.from(beanSpecsClass, builder -> builder);
        }

        public <PT> BeanContext<T> from(Class<? extends BeanSpecs<PT>> beanSpecsClass, Function<Builder<PT>, Builder<PT>> customerBuilder) {
            return this.from(customerBuilder.apply(BeanContext.this.getFactorySet().toBuild(beanSpecsClass)));
        }

        <PT> BeanContext<T> from(Builder<PT> builder) {
            if (BeanContext.this.isPropertyNotSpecified(this.property)) {
                BeanContext subBeanContext = builder.createSubBeanContext(BeanContext.this, this.property);
                this.from(() -> builder.subCreate(subBeanContext));
                subBeanContext.queryOrCreateReferenceBeansAndCollectAllSpecs();
            }
            return BeanContext.this;
        }

        public BeanContext<T> dependsOn(String dependency, Function<Object, Object> function) {
            return this.dependsOn(Collections.singletonList(dependency), (List<Object> list) -> function.apply(list.get(0)));
        }

        public BeanContext<T> dependsOn(List<String> dependencies, Function<List<Object>, Object> function) {
            if (BeanContext.this.isPropertyNotSpecified(this.property)) {
                PropertyChain propertyChain = new PropertyChain(BeanContext.this.absolutePropertyChain(this.property));
                BeanContext.this.buildingContext.appendDependencySpec(propertyChain, new DependencySpec(propertyChain, dependencies.stream().map(d -> new PropertyChain(BeanContext.this.absolutePropertyChain(d))).collect(Collectors.toList()), function));
            }
            return BeanContext.this;
        }

        public BeanContext<T> type(Class<?> type) {
            return this.type(type, builder -> builder);
        }

        public <PT> BeanContext<T> type(Class<PT> type, Function<Builder<PT>, Builder<PT>> customerBuilder) {
            return this.from(customerBuilder.apply(customerBuilder.apply(BeanContext.this.getFactorySet().type(type))));
        }
    }
}

