/*
 * Decompiled with CFR 0.152.
 */
package com.github.leeonky.javabuilder;

import com.github.leeonky.javabuilder.Builder;
import com.github.leeonky.javabuilder.FactorySet;
import java.util.stream.Stream;

class PropertyQueryChain {
    private final String baseName;
    private final String condition;
    private final String specificationName;
    private final String[] combinations;

    private PropertyQueryChain(String chain) {
        String[] propertyList = chain.split("\\.", 2);
        this.condition = propertyList[1];
        String propertyName = propertyList[0];
        if (propertyName.contains("(")) {
            String[] propertyFactory = propertyName.split("\\(");
            propertyName = propertyFactory[0];
            String[] combinedSpecificationName = propertyFactory[1].split("\\)")[0].split("[,\\ ]");
            this.combinations = (String[])Stream.of(combinedSpecificationName).limit(combinedSpecificationName.length - 1).map(String::trim).toArray(String[]::new);
            this.specificationName = combinedSpecificationName[combinedSpecificationName.length - 1].trim();
        } else {
            this.specificationName = null;
            this.combinations = new String[0];
        }
        this.baseName = propertyName;
    }

    static PropertyQueryChain parse(String chain) {
        return new PropertyQueryChain(chain);
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getCondition() {
        return this.condition;
    }

    Builder<?> toBuilder(FactorySet factorySet, Class<?> type, Object param) {
        return (this.specificationName != null ? factorySet.toBuild(this.specificationName) : factorySet.type(type)).combine(this.combinations).property(this.getCondition(), param);
    }
}

