/*
 * {{{ header & license
 * Copyright (c) 2005 Wisconsin Court System
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * }}}
 */
package org.openpdf.render;

import com.google.errorprone.annotations.CheckReturnValue;
import org.openpdf.css.style.CssContext;

import java.awt.*;

/**
 * A dummy box representing one side of the margin area of a page.
 */
public class MarginBox extends BlockBox {
    private final Rectangle _bounds;

    public MarginBox(Rectangle bounds) {
        _bounds = bounds;
    }

    @Override
    public int getWidth() {
        return _bounds.width;
    }

    @Override
    public int getHeight() {
        return _bounds.height;
    }

    @Override
    public int getContentWidth() {
        return _bounds.width;
    }

    @Override
    public Rectangle getContentAreaEdge(int left, int top, CssContext cssCtx) {
        return new Rectangle(-_bounds.x, -_bounds.y, _bounds.width, _bounds.height);
    }

    @CheckReturnValue
    @Override
    public Rectangle getPaddingEdge(int left, int top, CssContext cssCtx) {
        return new Rectangle(-_bounds.x, -_bounds.y, _bounds.width, _bounds.height);
    }

    @Override
    protected int getContainingBlockWidth() {
        return _bounds.width;
    }

    @Override
    protected int getPaddingWidth(CssContext cssCtx) {
        return _bounds.width;
    }

    @Override
    public BlockBox copyOf() {
        throw new IllegalArgumentException("cannot be copied");
    }
}
