/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.html.simpleparser;

import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class IncTable {
    private HashMap props = new HashMap();
    private ArrayList rows = new ArrayList();
    private ArrayList cols;

    public IncTable(HashMap props) {
        this.props.putAll(props);
    }

    public void addCol(PdfPCell cell) {
        if (this.cols == null) {
            this.cols = new ArrayList();
        }
        this.cols.add(cell);
    }

    public void addCols(ArrayList ncols) {
        if (this.cols == null) {
            this.cols = new ArrayList(ncols);
        } else {
            this.cols.addAll(ncols);
        }
    }

    public void endRow() {
        if (this.cols != null) {
            Collections.reverse(this.cols);
            this.rows.add(this.cols);
            this.cols = null;
        }
    }

    public ArrayList getRows() {
        return this.rows;
    }

    public PdfPTable buildTable() {
        if (this.rows.isEmpty()) {
            return new PdfPTable(1);
        }
        int ncol = 0;
        ArrayList c0 = (ArrayList)this.rows.get(0);
        for (Object o1 : c0) {
            ncol += ((PdfPCell)o1).getColspan();
        }
        PdfPTable table = new PdfPTable(ncol);
        String width = (String)this.props.get("width");
        if (width == null) {
            table.setWidthPercentage(100.0f);
        } else if (width.endsWith("%")) {
            table.setWidthPercentage(Float.parseFloat(width.substring(0, width.length() - 1)));
        } else {
            table.setTotalWidth(Float.parseFloat(width));
            table.setLockedWidth(true);
        }
        for (Object row1 : this.rows) {
            ArrayList col = (ArrayList)row1;
            for (Object o : col) {
                table.addCell((PdfPCell)o);
            }
        }
        return table;
    }
}

