/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.html.simpleparser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChainedProperties {
    public static final int[] fontSizes = new int[]{8, 10, 12, 14, 18, 24, 36};
    public List<Object[]> chain = new ArrayList<Object[]>();

    public String getProperty(String key) {
        for (int k = this.chain.size() - 1; k >= 0; --k) {
            Object[] obj = this.chain.get(k);
            HashMap prop = (HashMap)obj[1];
            String ret = (String)prop.get(key);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public boolean hasProperty(String key) {
        for (int k = this.chain.size() - 1; k >= 0; --k) {
            Object[] obj = this.chain.get(k);
            HashMap prop = (HashMap)obj[1];
            if (!prop.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public void addToChain(String key, Map<String, String> prop) {
        String value = prop.get("size");
        if (value != null) {
            if (value.endsWith("pt")) {
                prop.put("size", value.substring(0, value.length() - 2));
            } else {
                int s = 0;
                if (value.startsWith("+") || value.startsWith("-")) {
                    String old = this.getProperty("basefontsize");
                    if (old == null) {
                        old = "12";
                    }
                    float f = Float.parseFloat(old);
                    int c = (int)f;
                    for (int k = fontSizes.length - 1; k >= 0; --k) {
                        if (c < fontSizes[k]) continue;
                        s = k;
                        break;
                    }
                    int inc = Integer.parseInt(value.startsWith("+") ? value.substring(1) : value);
                    s += inc;
                } else {
                    try {
                        s = Integer.parseInt(value) - 1;
                    }
                    catch (NumberFormatException nfe) {
                        s = 0;
                    }
                }
                if (s < 0) {
                    s = 0;
                } else if (s >= fontSizes.length) {
                    s = fontSizes.length - 1;
                }
                prop.put("size", Integer.toString(fontSizes[s]));
            }
        }
        this.chain.add(new Object[]{key, prop});
    }

    public void removeChain(String key) {
        for (int k = this.chain.size() - 1; k >= 0; --k) {
            if (!key.equals(this.chain.get(k)[0])) continue;
            this.chain.remove(k);
            return;
        }
    }
}

