/*
 * Decompiled with CFR 0.152.
 */
package com.github.lit.code.executor;

import com.github.lit.code.config.Configuration;
import com.github.lit.code.context.Table;
import com.github.lit.code.context.Task;
import com.github.lit.code.plugin.PluginExecutor;
import com.github.lit.code.util.ClassUtils;
import com.github.lit.code.util.FileUtils;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.logging.Logger;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class GenerationExecutor {
    private static final Logger LOGGER = Logger.getLogger(GenerationExecutor.class.getName());

    public static void execute(Configuration configuration) {
        Table table = configuration.getTable();
        Boolean overwrite = configuration.getBooleanConstant("overwrite", true);
        Boolean onChildModule = configuration.getBooleanConstant("onChildModule");
        String rootDir = configuration.getConstant("rootDir", System.getProperty("user.dir"));
        if (onChildModule.booleanValue()) {
            rootDir = rootDir.substring(0, rootDir.lastIndexOf(File.separator));
        }
        VelocityContext context = new VelocityContext();
        context.put("table", (Object)table);
        context.put("constant", configuration.getConstantMap());
        List<String> tableTasks = table.getTasks();
        for (String tableTask : tableTasks) {
            Task task = configuration.getTask(tableTask);
            if (task == null) continue;
            task.setTableName(task.processTableName(table.getName()));
            context.put(task.getName(), (Object)task);
            GenerationExecutor.executePlugin(configuration, (Context)context, task);
            String targetDir = rootDir + File.separator + task.getModule();
            String filePath = targetDir + task.getFileName();
            String templateText = FileUtils.readToString(task.getTemplate());
            StringWriter stringWriter = new StringWriter();
            Velocity.evaluate((Context)context, (Writer)stringWriter, (String)"lit-code", (String)templateText);
            String resultText = stringWriter.toString();
            FileUtils.writeToFile(resultText, filePath, overwrite);
        }
    }

    private static void executePlugin(Configuration configuration, Context context, Task task) {
        List<String> plugins = task.getPlugins();
        if (plugins == null || plugins.isEmpty()) {
            return;
        }
        for (String plugin : plugins) {
            PluginExecutor pluginExecutor = (PluginExecutor)ClassUtils.newInstance(plugin);
            pluginExecutor.execute(configuration, context, task);
        }
    }
}

