/*
 * Decompiled with CFR 0.152.
 */
package com.github.lit.code.parser;

import com.github.lit.code.config.Configuration;
import com.github.lit.code.config.JdbcConfig;
import com.github.lit.code.context.Column;
import com.github.lit.code.context.GenerationException;
import com.github.lit.code.context.Table;
import com.github.lit.code.datebase.DataBaseProvider;
import com.github.lit.code.datebase.DateBaseProviderFactory;
import com.github.lit.code.parser.ConfigParser;
import com.github.lit.code.util.DBUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

public class TableParser
implements ConfigParser {
    private static final Logger LOGGER = Logger.getLogger(TableParser.class.getName());

    @Override
    public String getConfigKey() {
        return "table";
    }

    @Override
    public void parser(Configuration configuration, JsonElement jsonElement) {
        JdbcConfig jdbcConfig = configuration.getJdbcConfig();
        if (jdbcConfig == null) {
            throw new GenerationException("\u672a\u627e\u5230\u6570\u636e\u5e93\u8fde\u63a5\u914d\u7f6e, \u4e0d\u80fd\u89e3\u6790\u8868\u4fe1\u606f! \u5982\u679c\u4e0d\u9700\u8981\u89e3\u6790\u8868\u4fe1\u606f, \u8bf7\u5c06\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684 table \u914d\u7f6e\u5220\u9664!");
        }
        if (jsonElement.isJsonArray()) {
            throw new GenerationException("table \u914d\u7f6e\u9879\u4e0d\u80fd\u662f\u6570\u7ec4!");
        }
        Table table = (Table)new Gson().fromJson(jsonElement.toString(), Table.class);
        configuration.setTable(table);
        DBUtils.createConnection(configuration.getJdbcConfig());
        this.initTableMetaData(table);
        for (Column column : table.getColumns()) {
            String javaClass = configuration.getConverter(column.getJdbcType());
            if (javaClass != null && !javaClass.isEmpty()) {
                column.setJavaClass(javaClass);
            }
            column.setJavaType(column.getJavaClass().substring(column.getJavaClass().lastIndexOf(".") + 1));
        }
    }

    private void initTableMetaData(Table table) {
        Connection connection = DBUtils.getConnection();
        try {
            if (table.getCatalog() == null || table.getCatalog().isEmpty()) {
                table.setCatalog(connection.getCatalog());
            }
            if (table.getSchema() == null || table.getSchema().isEmpty()) {
                table.setSchema(connection.getSchema());
            }
            if (table.getQuoteString() == null || table.getQuoteString().isEmpty()) {
                table.setQuoteString(connection.getMetaData().getIdentifierQuoteString());
            }
            String dbName = connection.getMetaData().getDatabaseProductName();
            DataBaseProvider provider = DateBaseProviderFactory.getDataBaseProvider(dbName);
            Map<String, String> columnCommentMap = null;
            if (provider != null) {
                columnCommentMap = provider.getColumnComment(connection, table);
            } else {
                LOGGER.warning("\u672a\u80fd\u627e\u5230 " + dbName + " \u6570\u636e\u5e93\u67e5\u8be2\u5217\u5907\u6ce8\u4fe1\u606f\u7684provider!");
            }
            ResultSet primaryKeys = connection.getMetaData().getPrimaryKeys(table.getCatalog(), table.getSchema(), table.getName());
            while (primaryKeys.next()) {
                table.setPrimaryKey(primaryKeys.getString("COLUMN_NAME").toLowerCase());
            }
            String querySql = "select * from" + table.getFullTableName() + "where 1=2";
            LOGGER.info("\u67e5\u8be2\u8868\u5143\u6570\u636e, \u6267\u884csql: " + querySql);
            PreparedStatement ps = connection.prepareStatement(querySql);
            ResultSetMetaData tableMetaData = ps.executeQuery().getMetaData();
            ArrayList<Column> columns = new ArrayList<Column>(tableMetaData.getColumnCount());
            for (int i = 0; i < tableMetaData.getColumnCount(); ++i) {
                String comment;
                Column column = new Column();
                column.setName(tableMetaData.getColumnName(i + 1).toLowerCase());
                column.setJdbcType(tableMetaData.getColumnTypeName(i + 1));
                column.setJavaClass(tableMetaData.getColumnClassName(i + 1));
                column.setDisplaySize(tableMetaData.getColumnDisplaySize(i + 1));
                column.setScale(tableMetaData.getScale(i + 1));
                column.setAutoIncrement(tableMetaData.isAutoIncrement(i + 1));
                if (columnCommentMap != null && (comment = columnCommentMap.get(column.getName())) != null && !comment.isEmpty()) {
                    column.setComment(comment);
                }
                if (table.getPrimaryKey() == null || table.getPrimaryKey().isEmpty()) {
                    column.setPrimaryKey(false);
                } else {
                    column.setPrimaryKey(Objects.equals(column.getName(), table.getPrimaryKey()));
                }
                columns.add(column);
            }
            table.setColumns(columns);
        }
        catch (Exception e) {
            throw new GenerationException("\u521d\u59cb\u5316\u8868\u5143\u6570\u636e\u4fe1\u606f\u5f02\u5e38", e);
        }
        finally {
            DBUtils.closeConnection();
        }
    }
}

