/*
 * Decompiled with CFR 0.152.
 */
package com.github.lit.code.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

public class FileUtils {
    private static final Logger LOGGER = Logger.getLogger(FileUtils.class.getName());

    public static String readToString(String filePath) {
        InputStream inputStream;
        if (!filePath.startsWith(File.separator)) {
            filePath = File.separator + filePath;
        }
        if ((inputStream = FileUtils.class.getResourceAsStream(filePath)) == null) {
            return "";
        }
        return FileUtils.readToString(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readToString(InputStream inputStream) {
        byte[] b = new byte[4096];
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            int len;
            while ((len = inputStream.read(b, 0, b.length)) != -1) {
                outputStream.write(b, 0, len);
            }
            String string = outputStream.toString("UTF-8");
            return string;
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                inputStream.close();
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
        return "";
    }

    public static void writeToFile(String text, String filePath, boolean overwrite) {
        try {
            File file = new File(filePath);
            if (file.exists() && !overwrite) {
                LOGGER.info(String.format("file %s is exist, do nothing", filePath));
                return;
            }
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(text);
            fileWriter.flush();
            fileWriter.close();
            LOGGER.info(String.format("generate file: %s ", filePath));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

