/*
 * Decompiled with CFR 0.152.
 */
package com.github.lit.code.context;

import com.github.lit.code.context.Column;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Table
implements Serializable {
    private static final long serialVersionUID = -3416826548050707151L;
    private String catalog;
    private String schema;
    private String quoteString;
    private String name;
    private String primaryKey;
    private String desc;
    private List<Column> columns;
    private List<String> tasks;

    public String getFullTableName() {
        String result = " ";
        if (this.catalog != null && !this.catalog.isEmpty()) {
            result = result + this.catalog + ".";
        }
        if (this.schema != null && !this.schema.isEmpty()) {
            result = result + this.schema + ".";
        }
        return result + this.quoteString + this.name + this.quoteString + " ";
    }

    public Set<String> getImportClasses() {
        HashSet<String> importClasses = new HashSet<String>();
        for (Column column : this.columns) {
            if (column.getJavaClass().startsWith("java.lang")) continue;
            importClasses.add(column.getJavaClass());
        }
        return importClasses;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getQuoteString() {
        return this.quoteString;
    }

    public String getName() {
        return this.name;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public String getDesc() {
        return this.desc;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public List<String> getTasks() {
        return this.tasks;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setQuoteString(String quoteString) {
        this.quoteString = quoteString;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public void setTasks(List<String> tasks) {
        this.tasks = tasks;
    }

    public String toString() {
        return "Table(catalog=" + this.getCatalog() + ", schema=" + this.getSchema() + ", quoteString=" + this.getQuoteString() + ", name=" + this.getName() + ", primaryKey=" + this.getPrimaryKey() + ", desc=" + this.getDesc() + ", columns=" + this.getColumns() + ", tasks=" + this.getTasks() + ")";
    }
}

