/*
 * Decompiled with CFR 0.152.
 */
package com.github.lit.code.datebase;

import com.github.lit.code.datebase.DataBaseProvider;
import com.github.lit.code.datebase.MySqlProvider;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DateBaseProviderFactory {
    private static final Map<String, DataBaseProvider> PROVIDER_MAP = new ConcurrentHashMap<String, DataBaseProvider>();

    public static void registerProvider(DataBaseProvider dataBaseProvider) {
        PROVIDER_MAP.put(dataBaseProvider.getDbName().toUpperCase(), dataBaseProvider);
    }

    public static DataBaseProvider getDataBaseProvider(String dbName) {
        return PROVIDER_MAP.get(dbName.toUpperCase());
    }

    static {
        DateBaseProviderFactory.registerProvider(new MySqlProvider());
    }
}

