/*
 * Decompiled with CFR 0.152.
 */
package com.github.lit.code.util;

import com.github.lit.code.config.JdbcConfig;
import com.github.lit.code.context.GenerationException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class DBUtils {
    private static Connection connection;

    private static String getDriverClass(String dbName) {
        if (dbName == null || dbName.isEmpty()) {
            return dbName;
        }
        switch (dbName.toUpperCase()) {
            case "MYSQL": {
                return "com.mysql.jdbc.Driver";
            }
            case "ORACLE": {
                return "oracle.jdbc.driver.OracleDriver";
            }
        }
        return "";
    }

    public static synchronized void createConnection(JdbcConfig jdbcConfig) {
        try {
            if (jdbcConfig.getDriverClass() == null && jdbcConfig.getDbName() != null) {
                jdbcConfig.setDriverClass(DBUtils.getDriverClass(jdbcConfig.getDbName()));
                Class.forName(jdbcConfig.getDriverClass());
            }
            connection = DriverManager.getConnection(jdbcConfig.getUrl(), jdbcConfig.getUser(), jdbcConfig.getPassword());
            if (jdbcConfig.getDbName() == null || jdbcConfig.getDbName().isEmpty()) {
                jdbcConfig.setDbName(connection.getMetaData().getDatabaseProductName().toUpperCase());
            }
        }
        catch (Exception e) {
            throw new GenerationException("\u521b\u5efa\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25! \u68c0\u67e5\u8fde\u63a5\u4fe1\u606f\u662f\u5426\u6b63\u786e!", e);
        }
    }

    public static Connection getConnection() {
        try {
            if (connection == null || connection.isClosed()) {
                throw new GenerationException("\u6570\u636e\u5e93\u8fde\u63a5\u5df2\u5931\u6548, \u8bf7\u91cd\u65b0\u521b\u5efa!");
            }
            return connection;
        }
        catch (SQLException e) {
            throw new GenerationException("\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38!", e);
        }
    }

    public static void closeConnection() {
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

