/*
 * Decompiled with CFR 0.152.
 */
package com.github.lokic.javaplus;

import com.github.lokic.javaplus.functional.function.Function2;
import com.github.lokic.javaplus.functional.function.Function3;
import com.github.lokic.javaplus.tuple.Tuple;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class Memoized {
    public static <T, R> Function<T, R> of(Function<T, R> function) {
        ConcurrentHashMap cache = new ConcurrentHashMap(8);
        return t -> cache.computeIfAbsent(t, function);
    }

    public static <T1, T2, R> Function2<T1, T2, R> of(Function2<T1, T2, R> function2) {
        ConcurrentHashMap cache = new ConcurrentHashMap(8);
        return (t1, t2) -> cache.computeIfAbsent(Tuple.of(t1, t2), t -> function2.apply(t.getT1(), t.getT2()));
    }

    public static <T1, T2, T3, R> Function3<T1, T2, T3, R> of(Function3<T1, T2, T3, R> function3) {
        ConcurrentHashMap cache = new ConcurrentHashMap(8);
        return (t1, t2, t3) -> cache.computeIfAbsent(Tuple.of(t1, t2, t3), t -> function3.apply(t.getT1(), t.getT2(), t.getT3()));
    }
}

