/*
 * Decompiled with CFR 0.152.
 */
package com.github.lokic.javaplus;

import com.github.lokic.javaplus.functional.function.Function2;
import com.github.lokic.javaplus.functional.function.Function3;
import com.github.lokic.javaplus.functional.function.Function4;
import com.github.lokic.javaplus.functional.function.Function5;
import com.github.lokic.javaplus.functional.tuple.TupleFunction2;
import com.github.lokic.javaplus.functional.tuple.TupleFunction3;
import com.github.lokic.javaplus.functional.tuple.TupleFunction4;
import com.github.lokic.javaplus.functional.tuple.TupleFunction5;
import com.github.lokic.javaplus.functional.tuple.TupleFunction6;
import com.github.lokic.javaplus.tuple.Tuple;
import com.github.lokic.javaplus.tuple.Tuple2;
import com.github.lokic.javaplus.tuple.Tuple3;
import com.github.lokic.javaplus.tuple.Tuple4;
import com.github.lokic.javaplus.tuple.Tuple5;
import com.github.lokic.javaplus.tuple.Tuple6;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public class Streams {
    @SafeVarargs
    public static <T> Stream<T> ofNullable(T ... values) {
        return Stream.of(values).flatMap(Streams::ofNullable);
    }

    @SafeVarargs
    public static <T> Stream<T> ofNullable(Optional<T> ... optValues) {
        return Stream.of(optValues).map(Objects::requireNonNull).flatMap(Streams::ofNullable);
    }

    public static <T> Stream<T> ofNullable(T value) {
        return value == null ? Stream.empty() : Stream.of(value);
    }

    public static <T> Stream<T> ofNullable(Optional<T> option) {
        Objects.requireNonNull(option);
        return option.map(Stream::of).orElseGet(Stream::empty);
    }

    public static <T> Stream<T> ofNullable(Collection<T> values) {
        return values == null ? Stream.empty() : values.stream();
    }

    public static <T, R> Function<T, Stream<R>> ofCollectionNullable(Function<T, Collection<R>> function) {
        return t -> Streams.ofNullable((Collection)function.apply(t));
    }

    public static <T, R> Function<T, Stream<R>> ofObjectNullable(Function<T, R> function) {
        return t -> Streams.ofNullable(function.apply(t));
    }

    public static class Fors {
        private Fors() {
            throw new UnsupportedOperationException("The class cannot be instantiated");
        }

        public static <T1, T2> Function<T1, Stream<Tuple2<T1, T2>>> For(Function<T1, Stream<T2>> f) {
            return t1 -> ((Stream)f.apply(t1)).map(t2 -> Tuple.of(t1, t2));
        }

        public static <T1, T2, T3> Function<Tuple2<T1, T2>, Stream<Tuple3<T1, T2, T3>>> For(Function2<T1, T2, Stream<T3>> f) {
            return t -> ((Stream)f.apply(t.getT1(), t.getT2())).map(t3 -> Tuple.of(t.getT1(), t.getT2(), t3));
        }

        public static <T1, T2, T3, T4> Function<Tuple3<T1, T2, T3>, Stream<Tuple4<T1, T2, T3, T4>>> For(Function3<T1, T2, T3, Stream<T4>> f) {
            return t -> ((Stream)f.apply(t.getT1(), t.getT2(), t.getT3())).map(t4 -> Tuple.of(t.getT1(), t.getT2(), t.getT3(), t4));
        }

        public static <T1, T2, T3, T4, T5> Function<Tuple4<T1, T2, T3, T4>, Stream<Tuple5<T1, T2, T3, T4, T5>>> For(Function4<T1, T2, T3, T4, Stream<T5>> f) {
            return t -> ((Stream)f.apply(t.getT1(), t.getT2(), t.getT3(), t.getT4())).map(t5 -> Tuple.of(t.getT1(), t.getT2(), t.getT3(), t.getT4(), t5));
        }

        public static <T1, T2, T3, T4, T5, T6> Function<Tuple5<T1, T2, T3, T4, T5>, Stream<Tuple6<T1, T2, T3, T4, T5, T6>>> For(Function5<T1, T2, T3, T4, T5, Stream<T6>> f) {
            return t -> ((Stream)f.apply(t.getT1(), t.getT2(), t.getT3(), t.getT4(), t.getT5())).map(t6 -> Tuple.of(t.getT1(), t.getT2(), t.getT3(), t.getT4(), t.getT5(), t6));
        }

        public static <T1, R> Function<T1, R> Yield(Function<T1, R> f) {
            return f;
        }

        public static <T1, T2, R> Function<Tuple2<T1, T2>, R> Yield(TupleFunction2<T1, T2, R> f) {
            return f;
        }

        public static <T1, T2, T3, R> Function<Tuple3<T1, T2, T3>, R> Yield(TupleFunction3<T1, T2, T3, R> f) {
            return f;
        }

        public static <T1, T2, T3, T4, R> Function<Tuple4<T1, T2, T3, T4>, R> Yield(TupleFunction4<T1, T2, T3, T4, R> f) {
            return f;
        }

        public static <T1, T2, T3, T4, T5, R> Function<Tuple5<T1, T2, T3, T4, T5>, R> Yield(TupleFunction5<T1, T2, T3, T4, T5, R> f) {
            return f;
        }

        public static <T1, T2, T3, T4, T5, T6, R> Function<Tuple6<T1, T2, T3, T4, T5, T6>, R> Yield(TupleFunction6<T1, T2, T3, T4, T5, T6, R> f) {
            return f;
        }
    }
}

