/*
 * Decompiled with CFR 0.152.
 */
package com.github.lokic.javaplus;

import java.util.Optional;
import java.util.function.Consumer;

public class Optionals {
    public static <T> OptionalConsumer<T> ifPresentOrElse(Consumer<T> c, Runnable r) {
        return new OptionalConsumer<T>(c, r);
    }

    public static class OptionalConsumer<T>
    implements Consumer<Optional<T>> {
        private final Consumer<T> c;
        private final Runnable r;

        OptionalConsumer(Consumer<T> c, Runnable r) {
            this.c = c;
            this.r = r;
        }

        @Override
        public void accept(Optional<T> t) {
            if (t.isPresent()) {
                this.c.accept(t.get());
            } else {
                this.r.run();
            }
        }
    }
}

