/*
 * Decompiled with CFR 0.152.
 */
package com.github.lokic.javaplus;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;

public class Property<T extends Enum<T>, K> {
    private final Class<T> clazz;
    private final Map<K, T> map;

    public Property(@NonNull Class<T> clazz, @NonNull Function<T, K> function) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        this.clazz = clazz;
        this.map = Arrays.stream(clazz.getEnumConstants()).collect(Collectors.toMap(function, Function.identity()));
    }

    public T of(K k) {
        return (T)((Enum)this.map.get(k));
    }

    public Optional<T> optOf(K k) {
        return Optional.ofNullable(this.of(k));
    }

    public T requireOf(K k) {
        T t = this.of(k);
        if (t == null) {
            throw new IllegalStateException(this.clazz.getTypeName() + " not found [" + k + "]");
        }
        return t;
    }
}

