/*
 * Decompiled with CFR 0.152.
 */
package com.github.lokic.javaplus;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public class Streams {
    public static <T> Stream<T> ofNullable(T ... values) {
        return Stream.of(values).flatMap(Streams::ofNullable);
    }

    public static <T> Stream<T> ofNullable(Optional<T> ... optValues) {
        return Stream.of(optValues).map(Objects::requireNonNull).flatMap(Streams::ofNullable);
    }

    public static <T> Stream<T> ofNullable(T value) {
        return value == null ? Stream.empty() : Stream.of(value);
    }

    public static <T> Stream<T> ofNullable(Optional<T> option) {
        Objects.requireNonNull(option);
        return option.map(Stream::of).orElseGet(Stream::empty);
    }

    public static <T> Stream<T> ofNullable(Collection<T> values) {
        return values == null ? Stream.empty() : values.stream();
    }

    public static <T, R> Function<T, Stream<R>> ofCollectionNullable(Function<T, Collection<R>> function) {
        return t -> Streams.ofNullable((Collection)function.apply(t));
    }

    public static <T, R> Function<T, Stream<R>> ofObjectNullable(Function<T, R> function) {
        return t -> Streams.ofNullable(function.apply(t));
    }
}

