/*
 * Decompiled with CFR 0.152.
 */
package com.github.lokic.javaplus.property;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;

public class Property1<E extends Enum<E>, K> {
    private final Class<E> clazz;
    private final Map<K, E> map;

    public Property1(@NonNull Class<E> clazz, @NonNull Function<E, K> function) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        this.clazz = clazz;
        this.map = Arrays.stream(clazz.getEnumConstants()).collect(Collectors.toMap(function, Function.identity()));
    }

    public E of(K k) {
        return (E)((Enum)this.map.get(k));
    }

    public Optional<E> optOf(K k) {
        return Optional.ofNullable(this.of(k));
    }

    public E requireOf(K k) {
        E t = this.of(k);
        if (t == null) {
            throw new IllegalStateException(this.clazz.getTypeName() + " not found [" + k + "]");
        }
        return t;
    }
}

