/*
 * Decompiled with CFR 0.152.
 */
package com.github.lokic.javaplus;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.function.Function;

public interface Either<L, R> {
    public static <L, R> Either<L, R> left(L left) {
        return new Left(left);
    }

    public static <L, R> Either<L, R> right(R right) {
        return new Right(right);
    }

    public L getLeft();

    public R getRight();

    public boolean isLeft();

    public boolean isRight();

    default public <U> Either<L, U> flatMap(Function<? super R, ? extends Either<L, ? extends U>> mapper) {
        if (this.isRight()) {
            return mapper.apply(this.getRight());
        }
        return this;
    }

    public static final class Right<L, R>
    implements Either<L, R>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final R value;

        private Right(R value) {
            this.value = value;
        }

        @Override
        public L getLeft() {
            throw new NoSuchElementException("getLeft() at Right");
        }

        @Override
        public R getRight() {
            return this.value;
        }

        @Override
        public boolean isLeft() {
            return false;
        }

        @Override
        public boolean isRight() {
            return true;
        }

        public String toString() {
            return "Either.Right(value=" + this.value + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Right)) {
                return false;
            }
            Right other = (Right)o;
            R this$value = this.value;
            R other$value = other.value;
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            R $value = this.value;
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }
    }

    public static final class Left<L, R>
    implements Either<L, R>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final L value;

        private Left(L value) {
            this.value = value;
        }

        @Override
        public L getLeft() {
            return this.value;
        }

        @Override
        public R getRight() {
            throw new NoSuchElementException("getRight() at Left");
        }

        @Override
        public boolean isLeft() {
            return true;
        }

        @Override
        public boolean isRight() {
            return false;
        }

        public String toString() {
            return "Either.Left(value=" + this.value + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Left)) {
                return false;
            }
            Left other = (Left)o;
            L this$value = this.value;
            L other$value = other.value;
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            L $value = this.value;
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }
    }
}

