/*
 * Decompiled with CFR 0.152.
 */
package com.github.lokic.javaplus.specification;

import com.github.lokic.javaplus.specification.CompositeSpecification;
import com.github.lokic.javaplus.specification.Specification;
import java.util.function.Function;

public class ExpressionSpecification<T>
extends CompositeSpecification<T> {
    private static final ExpressionSpecification<?> TRUE_SPEC = new ExpressionSpecification<Object>(x -> true);
    private static final ExpressionSpecification<?> FALSE_SPEC = new ExpressionSpecification<Object>(x -> false);
    private final Function<T, Boolean> expression;

    public ExpressionSpecification(Function<T, Boolean> expression) {
        this.expression = expression;
    }

    @Override
    public boolean isSatisfiedBy(T entity) {
        return this.expression.apply(entity);
    }

    public static <T> Specification<T> trueSpec() {
        return TRUE_SPEC;
    }

    public static <T> Specification<T> falseSpec() {
        return FALSE_SPEC;
    }
}

