/*
 * Decompiled with CFR 0.152.
 */
package com.github.lokic.javaplus;

import com.github.lokic.javaplus.functional.function.Function2;
import com.github.lokic.javaplus.tuple.Tuple;
import com.github.lokic.javaplus.tuple.Tuple2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;

public class Collectors {
    public static <K, U, M extends Map<K, U>> Collector<Map.Entry<K, U>, ?, M> toMap(Supplier<M> mapSupplier) {
        return Collectors.toMap(Map.Entry::getValue, mapSupplier);
    }

    public static <T, K, U, M extends Map<K, T>> Collector<Map.Entry<K, U>, ?, M> toMap(Function<? super Map.Entry<K, U>, ? extends T> valueMapper, Supplier<M> mapSupplier) {
        return java.util.stream.Collectors.toMap(Map.Entry::getKey, valueMapper, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, mapSupplier);
    }

    public static <T1, T2, K, U, M extends Map<K, U>> Collector<Tuple2<T1, T2>, ?, M> toMap(Function2<? super T1, ? super T2, ? extends K> keyMapper, Function2<? super T1, ? super T2, ? extends U> valueMapper, BinaryOperator<U> mergeFunction, Supplier<M> mapSupplier) {
        return java.util.stream.Collectors.toMap((? super T t) -> keyMapper.apply((Object)t.getT1(), (Object)t.getT2()), (? super T t) -> valueMapper.apply((Object)t.getT1(), (Object)t.getT2()), mergeFunction, mapSupplier);
    }

    public static <T1, T2, K, U, M extends Map<K, U>> Collector<Tuple2<T1, T2>, ?, Stream<Map.Entry<K, U>>> toMapEntryStream(Function2<? super T1, ? super T2, ? extends K> keyMapper, Function2<? super T1, ? super T2, ? extends U> valueMapper, BinaryOperator<U> mergeFunction, Supplier<M> mapSupplier) {
        return Collectors.toMapEntryStream((? super T t) -> keyMapper.apply((Object)t.getT1(), (Object)t.getT2()), (? super T t) -> valueMapper.apply((Object)t.getT1(), (Object)t.getT2()), mergeFunction, mapSupplier);
    }

    public static <T, K, U, M extends Map<K, U>> Collector<T, ?, Stream<Map.Entry<K, U>>> toMapEntryStream(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction, Supplier<M> mapSupplier) {
        return java.util.stream.Collectors.collectingAndThen(java.util.stream.Collectors.toMap(keyMapper, valueMapper, mergeFunction, mapSupplier), m -> m.entrySet().stream());
    }

    public static <T1, T2, K, U, M extends Map<K, U>> Collector<Tuple2<T1, T2>, ?, Stream<Tuple2<K, U>>> toMapTupleStream(Function2<? super T1, ? super T2, ? extends K> keyMapper, Function2<? super T1, ? super T2, ? extends U> valueMapper, BinaryOperator<U> mergeFunction, Supplier<M> mapSupplier) {
        return Collectors.toMapTupleStream((? super T t) -> keyMapper.apply((Object)t.getT1(), (Object)t.getT2()), (? super T t) -> valueMapper.apply((Object)t.getT1(), (Object)t.getT2()), mergeFunction, mapSupplier);
    }

    public static <T, K, U, M extends Map<K, U>> Collector<T, ?, Stream<Tuple2<K, U>>> toMapTupleStream(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction, Supplier<M> mapSupplier) {
        return java.util.stream.Collectors.collectingAndThen(java.util.stream.Collectors.toMap(keyMapper, valueMapper, mergeFunction, mapSupplier), m -> m.entrySet().stream().map(e -> Tuple.of(e.getKey(), e.getValue())));
    }

    public static class Distinct {
        public static <T> Collector<T, ?, List<T>> distinctLastPut() {
            return Distinct.distinctByKey(Function.identity(), Order.LAST_PUT);
        }

        public static <T> Collector<T, ?, List<T>> distinctLastPutByKey(Function<? super T, ?> keyExtractor) {
            return Distinct.distinctByKey(keyExtractor, Order.LAST_PUT);
        }

        public static <T> Collector<T, ?, List<T>> distinctFirstPut() {
            return Distinct.distinctByKey(Function.identity(), Order.FIRST_PUT);
        }

        public static <T> Collector<T, ?, List<T>> distinctFirstPutByKey(Function<? super T, ?> keyExtractor) {
            return Distinct.distinctByKey(keyExtractor, Order.FIRST_PUT);
        }

        private static <T> Collector<T, ?, List<T>> distinctByKey(Function<? super T, ?> keyExtractor, Order order) {
            return java.util.stream.Collectors.collectingAndThen(java.util.stream.Collectors.toMap(keyExtractor, Function.identity(), (a, b) -> Distinct.merge(order, a, b), () -> Distinct.buildMap(order)), res -> new ArrayList(res.values()));
        }

        private static <T> T merge(Order order, T a, T b) {
            switch (order) {
                case FIRST_PUT: {
                    return a;
                }
                case LAST_PUT: {
                    return b;
                }
            }
            throw new IllegalStateException("not support order = " + (Object)((Object)order));
        }

        private static <K, V> Map<K, V> buildMap(Order order) {
            switch (order) {
                case FIRST_PUT: {
                    return new LinkedHashMap();
                }
                case LAST_PUT: {
                    return new LinkedHashMap(16, 0.75f, true);
                }
            }
            throw new IllegalStateException("not support order = " + (Object)((Object)order));
        }

        private static enum Order {
            FIRST_PUT,
            LAST_PUT;

        }
    }

    public static class Reversed {
        public static <T> Collector<T, ?, List<T>> reversed() {
            return Reversed.reversed(Function.identity());
        }

        public static <T, R> Collector<T, ?, R> reversed(Function<List<T>, R> finisher) {
            return java.util.stream.Collectors.collectingAndThen(java.util.stream.Collectors.toList(), list -> {
                Collections.reverse(list);
                return finisher.apply((List)list);
            });
        }
    }
}

