/*
 * Decompiled with CFR 0.152.
 */
package com.github.lokic.javaplus.join;

import com.github.lokic.javaplus.join.JoinOn;
import com.github.lokic.javaplus.join.JoinType;
import com.github.lokic.javaplus.tuple.Tuple;
import java.util.function.Function;
import java.util.stream.Stream;

public class JoinStream<T> {
    private final Stream<T> left;

    JoinStream(Stream<T> left) {
        this.left = left;
    }

    public Stream<T> stream() {
        return this.left;
    }

    public <R> Stream<R> flattenStream(Function<? super T, ? extends R> mapper) {
        return this.left.map(mapper);
    }

    public <U, K, R> JoinStream<R> innerJoin(Stream<U> right, JoinOn<T, U, K, R> on) {
        Stream<R> stream = this.innerJoin(right).on(on.getLeftKey(), on.getRightKey()).flattenStream(on.getFlatten());
        return new JoinStream<R>(stream);
    }

    public <U, K, R> JoinStream<R> leftOuterJoin(Stream<U> right, JoinOn<T, U, K, R> on) {
        Stream<R> stream = this.leftOuterJoin(right).on(on.getLeftKey(), on.getRightKey()).flattenStream(on.getFlatten());
        return new JoinStream<R>(stream);
    }

    public <U, K, R> JoinStream<R> rightOuterJoin(Stream<U> right, JoinOn<T, U, K, R> on) {
        Stream<Object> stream = super.leftOuterJoin(this.left).on(on.getRightKey(), on.getLeftKey()).flattenStream(t -> on.getFlatten().apply(Tuple.of(t.getT2(), t.getT1())));
        return new JoinStream<Object>(stream);
    }

    public <U, K, R> JoinStream<R> fullOuterJoin(Stream<U> right, JoinOn<T, U, K, R> on) {
        Stream<R> stream = this.fullOuterJoin(right).on(on.getLeftKey(), on.getRightKey()).flattenStream(on.getFlatten());
        return new JoinStream<R>(stream);
    }

    private <U> JoinType<T, U> innerJoin(Stream<U> right) {
        return new JoinType<T, U>(this.left, right, t -> t.getT1() != null && t.getT2() != null);
    }

    private <U> JoinType<T, U> leftOuterJoin(Stream<U> right) {
        return new JoinType<T, U>(this.left, right, t -> t.getT1() != null);
    }

    private <U> JoinType<T, U> fullOuterJoin(Stream<U> right) {
        return new JoinType<T, U>(this.left, right, t -> t.getT1() != null || t.getT2() != null);
    }
}

