/*
 * Decompiled with CFR 0.152.
 */
package com.github.lokic.javaplus.join;

import com.github.lokic.javaplus.Functions;
import com.github.lokic.javaplus.NullData;
import com.github.lokic.javaplus.join.JoinStream;
import com.github.lokic.javaplus.tuple.Tuple;
import com.github.lokic.javaplus.tuple.Tuple2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JoinType<T1, T2> {
    private final Stream<IndexWithData<Integer, Tuple2<T1, T2>>> leftWrappedStream;
    private final Stream<IndexWithData<Integer, Tuple2<T1, T2>>> rightWrappedStream;
    private final Predicate<Tuple2<T1, T2>> joinMatcher;

    JoinType(Stream<T1> left, Stream<T2> right, Predicate<Tuple2<T1, T2>> joinMatcher) {
        this.leftWrappedStream = left.map(l -> Tuple.of(Objects.requireNonNull(l), null)).map(Functions.mapWithIndex(IndexWithData::new));
        this.rightWrappedStream = right.map(r -> Tuple.of(null, Objects.requireNonNull(r))).map(Functions.mapWithIndex(IndexWithData::new));
        this.joinMatcher = joinMatcher;
    }

    public <K> JoinStream<Tuple2<T1, T2>> on(Function<T1, K> leftKey, Function<T2, K> rightKey) {
        Stream<Tuple2> stream = Stream.concat(this.leftWrappedStream, this.rightWrappedStream).collect(Collectors.toMap(t -> this.matchKey((Tuple2)t.getData(), leftKey, rightKey), Collections::singletonList, (a, b) -> {
            ArrayList li = new ArrayList();
            li.addAll(a);
            li.addAll(b);
            return li;
        }, LinkedHashMap::new)).values().stream().flatMap(this::cartesian).sorted(this::compare).filter(t -> this.joinMatcher.test((Tuple2<T1, T2>)t.getData())).map(IndexWithData::getData);
        return new JoinStream<Tuple2<T1, T2>>(stream);
    }

    private Stream<IndexWithData<Tuple2<Integer, Integer>, Tuple2<T1, T2>>> cartesian(List<IndexWithData<Integer, Tuple2<T1, T2>>> li) {
        Map map = li.stream().collect(Collectors.partitioningBy(t -> this.isLeft((Tuple2)t.getData()), this.toListOrNullList()));
        List left = map.get(true);
        List right = map.get(false);
        return left.stream().flatMap(l -> right.stream().map(r -> this.merge((IndexWithData<Integer, Tuple2<T1, T2>>)l, (IndexWithData<Integer, Tuple2<T1, T2>>)r)));
    }

    private IndexWithData<Tuple2<Integer, Integer>, Tuple2<T1, T2>> merge(IndexWithData<Integer, Tuple2<T1, T2>> l, IndexWithData<Integer, Tuple2<T1, T2>> r) {
        return new IndexWithData<Tuple2<Integer, Integer>, Tuple2<T1, T2>>(Tuple.of(l == null ? null : l.getIndex(), r == null ? null : r.getIndex()), Tuple.of(l == null ? null : (Object)l.getData().getT1(), r == null ? null : (Object)r.getData().getT2()));
    }

    private boolean isLeft(Tuple2<T1, T2> t) {
        return t.getT1() != null;
    }

    private <K> K matchKey(Tuple2<T1, T2> t, Function<T1, K> leftKey, Function<T2, K> rightKey) {
        if (t.getT1() != null) {
            return leftKey.apply(t.getT1());
        }
        if (t.getT2() != null) {
            return rightKey.apply(t.getT2());
        }
        throw new IllegalStateException("t1 == null and t2 == null");
    }

    private <T> Collector<T, List<T>, List<T>> toListOrNullList() {
        return Collector.of(ArrayList::new, List::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, l -> {
            if (l == null || l.isEmpty()) {
                return NullData.nullList();
            }
            return l;
        }, new Collector.Characteristics[0]);
    }

    private int compare(IndexWithData<Tuple2<Integer, Integer>, Tuple2<T1, T2>> a, IndexWithData<Tuple2<Integer, Integer>, Tuple2<T1, T2>> b) {
        Tuple2<Integer, Integer> aIndex = a.getIndex();
        Tuple2<Integer, Integer> bIndex = b.getIndex();
        int cmp = this.compare(aIndex.getT1(), bIndex.getT1());
        if (cmp == 0) {
            return this.compare(aIndex.getT2(), bIndex.getT2());
        }
        return cmp;
    }

    private int compare(Integer a, Integer b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return 1;
        }
        if (b == null) {
            return -1;
        }
        return Integer.compare(a, b);
    }

    private static class IndexWithData<K, T> {
        private K index;
        private T data;

        public IndexWithData(K index, T data) {
            this.index = index;
            this.data = data;
        }

        public K getIndex() {
            return this.index;
        }

        public T getData() {
            return this.data;
        }
    }
}

