/*
 * Decompiled with CFR 0.152.
 */
package com.github.martincooper.datatable;

import com.github.martincooper.datatable.ColumnValuePair;
import com.github.martincooper.datatable.DataRow;
import com.github.martincooper.datatable.DataRowCollectionBase;
import com.github.martincooper.datatable.DataTable;
import com.github.martincooper.datatable.DataTableException;
import com.github.martincooper.datatable.IDataColumn;
import io.vavr.API;
import io.vavr.Patterns;
import io.vavr.collection.Seq;
import io.vavr.collection.Stream;
import io.vavr.control.Try;

public class DataRowCollectionModifiable
extends DataRowCollectionBase {
    private DataRowCollectionModifiable(DataTable table, Iterable<DataRow> rows) {
        super(table, rows);
    }

    public Try<DataTable> addValues(Object ... rowValues) {
        return this.add(rowValues);
    }

    public Try<DataTable> add(Object[] rowValues) {
        return (Try)API.Match(this.mapValuesToColumns((Seq<Object>)Stream.of((Object[])rowValues))).of(new API.Match.Case[]{API.Case((API.Match.Pattern1)Patterns.$Success((API.Match.Pattern)API.$()), this::addRow), API.Case((API.Match.Pattern1)Patterns.$Failure((API.Match.Pattern)API.$()), Try::failure)});
    }

    public Try<DataTable> insertValues(int idx, Object ... rowValues) {
        return this.insert(idx, rowValues);
    }

    public Try<DataTable> insert(int idx, Object[] rowValues) {
        return (Try)API.Match(this.mapValuesToColumns((Seq<Object>)Stream.of((Object[])rowValues))).of(new API.Match.Case[]{API.Case((API.Match.Pattern1)Patterns.$Success((API.Match.Pattern)API.$()), values -> this.insertRow(idx, (Seq<ColumnValuePair>)values)), API.Case((API.Match.Pattern1)Patterns.$Failure((API.Match.Pattern)API.$()), Try::failure)});
    }

    public Try<DataTable> replaceValues(int idx, Object ... rowValues) {
        return this.replace(idx, rowValues);
    }

    public Try<DataTable> replace(int idx, Object[] rowValues) {
        return (Try)API.Match(this.mapValuesToColumns((Seq<Object>)Stream.of((Object[])rowValues))).of(new API.Match.Case[]{API.Case((API.Match.Pattern1)Patterns.$Success((API.Match.Pattern)API.$()), values -> this.replaceRow(idx, (Seq<ColumnValuePair>)values)), API.Case((API.Match.Pattern1)Patterns.$Failure((API.Match.Pattern)API.$()), Try::failure)});
    }

    public Try<DataTable> remove(int idx) {
        return this.removeRow(idx);
    }

    private Try<DataTable> addRow(Seq<ColumnValuePair> values) {
        Try<Seq<IDataColumn>> newCols = this.toSequence((Seq<Try<IDataColumn>>)values.map(val -> val.column().add(val.value())));
        return this.buildTable(newCols);
    }

    private Try<DataTable> insertRow(int idx, Seq<ColumnValuePair> values) {
        Try<Seq<IDataColumn>> newCols = this.toSequence((Seq<Try<IDataColumn>>)values.map(val -> val.column().insert(idx, val.value())));
        return this.buildTable(newCols);
    }

    private Try<DataTable> replaceRow(int idx, Seq<ColumnValuePair> values) {
        Try<Seq<IDataColumn>> newCols = this.toSequence((Seq<Try<IDataColumn>>)values.map(val -> val.column().replace(idx, val.value())));
        return this.buildTable(newCols);
    }

    private Try<DataTable> removeRow(int idx) {
        Try<Seq<IDataColumn>> cols = this.toSequence(this.table.columns().map((? super IDataColumn col) -> col.remove(idx)));
        return this.buildTable(cols);
    }

    private Try<DataTable> buildTable(Try<Seq<IDataColumn>> columns) {
        return (Try)API.Match(columns).of(new API.Match.Case[]{API.Case((API.Match.Pattern1)Patterns.$Success((API.Match.Pattern)API.$()), cols -> DataTable.build(this.table.name(), (Iterable<IDataColumn>)cols)), API.Case((API.Match.Pattern1)Patterns.$Failure((API.Match.Pattern)API.$()), Try::failure)});
    }

    private Try<Seq<ColumnValuePair>> mapValuesToColumns(Seq<Object> values) {
        return values.length() != this.table.columns().count() ? DataTableException.tryError("Number of values does not match number of columns.") : Try.success(this.createIndexedColumnValuePair(values));
    }

    private Seq<ColumnValuePair> createIndexedColumnValuePair(Seq<Object> values) {
        return values.zipWithIndex((value, index) -> new ColumnValuePair(this.table.column((Integer)index), value));
    }

    private Try<Seq<IDataColumn>> toSequence(Seq<Try<IDataColumn>> items) {
        return Try.sequence(items);
    }

    public static DataRowCollectionModifiable build(DataTable table) {
        return DataRowCollectionModifiable.buildRowCollection(table, DataRowCollectionModifiable::new);
    }
}

