/*
 * Decompiled with CFR 0.152.
 */
package com.github.martincooper.datatable;

import com.github.martincooper.datatable.DataColumnCollection;
import com.github.martincooper.datatable.DataRow;
import com.github.martincooper.datatable.DataRowCollection;
import com.github.martincooper.datatable.DataTable;
import com.github.martincooper.datatable.IBaseTable;
import com.github.martincooper.datatable.IDataColumn;
import com.github.martincooper.datatable.TransformCollector;
import com.github.martincooper.datatable.sorting.DataSort;
import com.github.martincooper.datatable.sorting.SortItem;
import com.github.martincooper.datatable.sorting.SortOrder;
import io.vavr.API;
import io.vavr.Patterns;
import io.vavr.collection.Seq;
import io.vavr.collection.Stream;
import io.vavr.control.Try;
import java.util.Iterator;

public class DataView
implements IBaseTable {
    private final DataTable table;
    private final DataRowCollection rows;

    private DataView(DataTable table, DataRowCollection rows) {
        this.table = table;
        this.rows = rows;
    }

    @Override
    public Iterator<DataRow> iterator() {
        return this.rows.iterator();
    }

    @Override
    public String name() {
        return this.table.name();
    }

    @Override
    public DataColumnCollection columns() {
        return this.table.columns();
    }

    @Override
    public DataRowCollection rows() {
        return this.rows;
    }

    @Override
    public DataRow row(Integer rowIdx) {
        return this.rows.get(rowIdx);
    }

    public IDataColumn column(Integer colIdx) {
        return this.table.column(colIdx);
    }

    public IDataColumn column(String colName) {
        return this.table.column(colName);
    }

    @Override
    public Integer rowCount() {
        return this.rows().rowCount();
    }

    @Override
    public DataTable toDataTable() {
        Seq rowIndexes = this.rows.map(DataRow::rowIdx);
        return (DataTable)this.table.columns().map(col -> (IDataColumn)col.buildFromRows((Seq<Integer>)rowIndexes).get()).collect(TransformCollector.transform(cols -> (DataTable)DataTable.build(this.name(), (Stream<IDataColumn>)cols).get()));
    }

    @Override
    public DataView toDataView() {
        return (DataView)DataView.build(this.table, this.rows).get();
    }

    @Override
    public Try<DataView> quickSort(String columnName) {
        return this.quickSort(columnName, SortOrder.Ascending);
    }

    @Override
    public Try<DataView> quickSort(String columnName, SortOrder sortOrder) {
        SortItem sortItem = new SortItem(columnName, sortOrder);
        return DataSort.quickSort(this.table, (Seq<DataRow>)this.rows.asSeq(), (Seq<SortItem>)Stream.of((Object)sortItem));
    }

    @Override
    public Try<DataView> quickSort(Integer columnIndex) {
        return this.quickSort(columnIndex, SortOrder.Ascending);
    }

    @Override
    public Try<DataView> quickSort(Integer columnIndex, SortOrder sortOrder) {
        SortItem sortItem = new SortItem(columnIndex, sortOrder);
        return DataSort.quickSort(this.table, (Seq<DataRow>)this.rows.asSeq(), (Seq<SortItem>)Stream.of((Object)sortItem));
    }

    @Override
    public Try<DataView> quickSort(SortItem sortItem) {
        return this.quickSort((Iterable<SortItem>)Stream.of((Object)sortItem));
    }

    @Override
    public Try<DataView> quickSort(Iterable<SortItem> sortItems) {
        return DataSort.quickSort(this.table, (Seq<DataRow>)this.rows.asSeq(), (Seq<SortItem>)Stream.ofAll(sortItems));
    }

    public static Try<DataView> build(DataTable table, Iterable<DataRow> rows) {
        return (Try)API.Match(DataRowCollection.build(table, rows)).of(new API.Match.Case[]{API.Case((API.Match.Pattern1)Patterns.$Success((API.Match.Pattern)API.$()), dataRows -> Try.success((Object)new DataView(table, (DataRowCollection)dataRows))), API.Case((API.Match.Pattern1)Patterns.$Failure((API.Match.Pattern)API.$()), Try::failure)});
    }
}

