/*
 * Decompiled with CFR 0.152.
 */
package com.github.martincooper.datatable;

import com.github.martincooper.datatable.DataTableException;
import io.vavr.collection.Vector;
import io.vavr.control.Try;

public class VectorExtensions {
    public static <T> Try<Vector<T>> addItem(Vector<T> vector, T item) {
        return Try.success((Object)vector.append(item));
    }

    public static <T> Try<Vector<T>> insertItem(Vector<T> vector, Integer index, T item) {
        return VectorExtensions.outOfBounds(vector, index) ? VectorExtensions.error("Item index out of bounds for insert.") : Try.success((Object)vector.insert(index.intValue(), item));
    }

    public static <T> Try<Vector<T>> removeItem(Vector<T> vector, Integer index) {
        return VectorExtensions.outOfBounds(vector, index) ? VectorExtensions.error("Item index out of bounds for remove.") : Try.success((Object)vector.removeAt(index.intValue()));
    }

    public static <T> Try<Vector<T>> replaceItem(Vector<T> vector, Integer index, T item) {
        return VectorExtensions.outOfBounds(vector, index) ? VectorExtensions.error("Item index out of bounds for replace.") : Try.success((Object)vector.update(index.intValue(), item));
    }

    public static boolean outOfBounds(Vector vector, Integer index) {
        return VectorExtensions.outOfBounds(vector.length(), index);
    }

    public static boolean outOfBounds(Integer itemCount, Integer index) {
        return itemCount == 0 || index < 0 || index >= itemCount;
    }

    private static <T> Try<Vector<T>> error(String errorMessage) {
        return DataTableException.tryError(errorMessage);
    }
}

