/*
 * Decompiled with CFR 0.152.
 */
package com.github.martincooper.datatable;

import com.github.martincooper.datatable.DataTableException;
import com.github.martincooper.datatable.GenericExtensions;
import com.github.martincooper.datatable.IDataColumn;
import io.vavr.API;
import io.vavr.CheckedFunction0;
import io.vavr.Patterns;
import io.vavr.collection.Seq;
import io.vavr.collection.Vector;
import io.vavr.control.Try;
import java.io.Serializable;
import java.lang.reflect.Type;

public class DataColumn<T>
implements IDataColumn {
    private final Class<T> type;
    private final String name;
    private final Vector<T> data;

    public DataColumn(Class<T> type, String columnName) {
        this(type, columnName, Vector.empty());
    }

    public DataColumn(Class<T> type, String columnName, T[] data) {
        this(type, columnName, Vector.of((Object[])data));
    }

    public DataColumn(Class<T> type, String columnName, Iterable<T> data) {
        this(type, columnName, Vector.ofAll(data));
    }

    public DataColumn(Class<T> type, String columnName, Vector<T> data) {
        this.type = type;
        this.name = columnName;
        this.data = data;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Type type() {
        return this.type;
    }

    public Vector<T> data() {
        return this.data;
    }

    public T valueAt(Integer rowIndex) {
        return (T)this.data.get(rowIndex.intValue());
    }

    @Override
    public <V> Try<DataColumn<V>> asType(Class<V> type) {
        return this.type == type ? Try.success((Object)this) : DataTableException.tryError("Column type doesn't match type requested.");
    }

    @Override
    public Try<IDataColumn> buildFromRows(Seq<Integer> rowIndexes) {
        Seq rowData = rowIndexes.map(arg_0 -> this.data.get(arg_0));
        return Try.success(new DataColumn<T>(this.type, this.name, rowData));
    }

    @Override
    public Try<IDataColumn> add(Object value) {
        return (Try)API.Match(GenericExtensions.tryCast(this.type, value)).of(new API.Match.Case[]{API.Case((API.Match.Pattern1)Patterns.$Success((API.Match.Pattern)API.$()), typedVal -> Try.of((CheckedFunction0 & Serializable)() -> this.createColumn(this.data.append(typedVal)))), API.Case((API.Match.Pattern1)Patterns.$Failure((API.Match.Pattern)API.$()), DataTableException.tryError("tryAdd failed. Item of invalid type passed."))});
    }

    @Override
    public Try<IDataColumn> insert(Integer index, Object value) {
        return (Try)API.Match(GenericExtensions.tryCast(this.type, value)).of(new API.Match.Case[]{API.Case((API.Match.Pattern1)Patterns.$Success((API.Match.Pattern)API.$()), typedVal -> Try.of((CheckedFunction0 & Serializable)() -> this.createColumn(this.data.insert(index.intValue(), typedVal)))), API.Case((API.Match.Pattern1)Patterns.$Failure((API.Match.Pattern)API.$()), DataTableException.tryError("tryInsert failed. Item of invalid type passed."))});
    }

    @Override
    public Try<IDataColumn> replace(Integer index, Object value) {
        return (Try)API.Match(GenericExtensions.tryCast(this.type, value)).of(new API.Match.Case[]{API.Case((API.Match.Pattern1)Patterns.$Success((API.Match.Pattern)API.$()), typedVal -> Try.of((CheckedFunction0 & Serializable)() -> this.createColumn(this.data.update(index.intValue(), typedVal)))), API.Case((API.Match.Pattern1)Patterns.$Failure((API.Match.Pattern)API.$()), DataTableException.tryError("tryReplace failed. Item of invalid type passed."))});
    }

    @Override
    public Try<IDataColumn> remove(Integer index) {
        return Try.of((CheckedFunction0 & Serializable)() -> this.createColumn(this.data.removeAt(index.intValue())));
    }

    public Try<DataColumn<T>> addItem(T value) {
        return Try.success(this.createColumn(this.data.append(value)));
    }

    public Try<DataColumn<T>> insertItem(Integer index, T value) {
        return Try.of((CheckedFunction0 & Serializable)() -> this.createColumn(this.data.insert(index.intValue(), value)));
    }

    public Try<DataColumn<T>> replaceItem(Integer index, T value) {
        return Try.of((CheckedFunction0 & Serializable)() -> this.createColumn(this.data.update(index.intValue(), value)));
    }

    public Try<DataColumn<T>> removeItem(Integer index) {
        return Try.of((CheckedFunction0 & Serializable)() -> this.createColumn(this.data.removeAt(index.intValue())));
    }

    private DataColumn<T> createColumn(Vector<T> data) {
        return new DataColumn<T>(this.type, this.name, data);
    }

    @Override
    public boolean IsComparable() {
        return Comparable.class.isAssignableFrom(this.type);
    }
}

