/*
 * Decompiled with CFR 0.152.
 */
package com.github.martincooper.datatable;

import com.github.martincooper.datatable.DataColumnCollection;
import com.github.martincooper.datatable.DataRow;
import com.github.martincooper.datatable.DataRowCollectionModifiable;
import com.github.martincooper.datatable.DataTableException;
import com.github.martincooper.datatable.DataView;
import com.github.martincooper.datatable.IBaseTable;
import com.github.martincooper.datatable.IDataColumn;
import com.github.martincooper.datatable.sorting.DataSort;
import com.github.martincooper.datatable.sorting.SortItem;
import com.github.martincooper.datatable.sorting.SortOrder;
import io.vavr.API;
import io.vavr.Patterns;
import io.vavr.collection.Map;
import io.vavr.collection.Seq;
import io.vavr.collection.Stream;
import io.vavr.collection.Vector;
import io.vavr.control.Try;
import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

public class DataTable
implements IBaseTable {
    private final String name;
    private final DataRowCollectionModifiable rows;
    private final DataColumnCollection columns;

    private DataTable(String tableName) {
        this.name = tableName;
        this.columns = new DataColumnCollection(this);
        this.rows = DataRowCollectionModifiable.build(this);
    }

    private DataTable(String tableName, Iterable<IDataColumn> columns) {
        this.name = tableName;
        this.columns = new DataColumnCollection(this, columns);
        this.rows = DataRowCollectionModifiable.build(this);
    }

    @Override
    public Iterator<DataRow> iterator() {
        return this.rows.iterator();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public DataColumnCollection columns() {
        return this.columns;
    }

    @Override
    public DataRowCollectionModifiable rows() {
        return this.rows;
    }

    @Override
    public Integer rowCount() {
        return this.columns.count() > 0 ? this.columns.get(0).data().length() : 0;
    }

    @Override
    public DataTable toDataTable() {
        return (DataTable)DataTable.build(this.name, this.columns).get();
    }

    @Override
    public DataView toDataView() {
        return (DataView)DataView.build(this, this.rows).get();
    }

    public DataView filter(Predicate<DataRow> predicate) {
        return this.rows.filter((Predicate)predicate);
    }

    public <U> Seq<U> map(Function<? super DataRow, ? extends U> mapper) {
        return this.rows.map((Function)mapper);
    }

    public <U> Seq<U> flatMap(Function<? super DataRow, ? extends Iterable<? extends U>> mapper) {
        return this.rows.flatMap((Function)mapper);
    }

    public DataRow reduce(BiFunction<? super DataRow, ? super DataRow, ? extends DataRow> reducer) {
        return this.rows.reduce((BiFunction)reducer);
    }

    public <C> Map<C, Vector<DataRow>> groupBy(Function<? super DataRow, ? extends C> grouper) {
        return this.rows.groupBy((Function)grouper);
    }

    public <U> U foldLeft(U zero, BiFunction<? super U, ? super DataRow, ? extends U> folder) {
        return (U)this.rows.foldLeft((Object)zero, (BiFunction)folder);
    }

    public <U> U foldRight(U zero, BiFunction<? super DataRow, ? super U, ? extends U> folder) {
        return (U)this.rows.foldRight((Object)zero, (BiFunction)folder);
    }

    @Override
    public DataRow row(Integer rowIdx) {
        return this.rows.get(rowIdx);
    }

    public IDataColumn column(Integer colIdx) {
        return this.columns.get(colIdx);
    }

    public IDataColumn column(String colName) {
        return this.columns.get(colName);
    }

    @Override
    public Try<DataView> quickSort(String columnName) {
        return this.quickSort(columnName, SortOrder.Ascending);
    }

    @Override
    public Try<DataView> quickSort(String columnName, SortOrder sortOrder) {
        SortItem sortItem = new SortItem(columnName, sortOrder);
        return DataSort.quickSort(this, (Seq<DataRow>)this.rows.asSeq(), (Seq<SortItem>)Stream.of((Object)sortItem));
    }

    @Override
    public Try<DataView> quickSort(Integer columnIndex) {
        return this.quickSort(columnIndex, SortOrder.Ascending);
    }

    @Override
    public Try<DataView> quickSort(Integer columnIndex, SortOrder sortOrder) {
        SortItem sortItem = new SortItem(columnIndex, sortOrder);
        return DataSort.quickSort(this, (Seq<DataRow>)this.rows.asSeq(), (Seq<SortItem>)Stream.of((Object)sortItem));
    }

    @Override
    public Try<DataView> quickSort(SortItem sortItem) {
        return this.quickSort((Iterable<SortItem>)Stream.of((Object)sortItem));
    }

    @Override
    public Try<DataView> quickSort(Iterable<SortItem> sortItems) {
        return DataSort.quickSort(this, (Seq<DataRow>)this.rows.asSeq(), (Seq<SortItem>)Stream.ofAll(sortItems));
    }

    public static DataTable build(String tableName) {
        return new DataTable(tableName);
    }

    public static Try<DataTable> build(String tableName, IDataColumn[] columns) {
        return DataTable.build(tableName, (Stream<IDataColumn>)Stream.of((Object[])columns));
    }

    public static Try<DataTable> build(String tableName, Iterable<IDataColumn> columns) {
        return DataTable.build(tableName, (Stream<IDataColumn>)Stream.ofAll(columns));
    }

    public static Try<DataTable> build(String tableName, Stream<IDataColumn> columns) {
        return (Try)API.Match(DataTable.validateColumns(columns)).of(new API.Match.Case[]{API.Case((API.Match.Pattern1)Patterns.$Success((API.Match.Pattern)API.$()), cols -> Try.success((Object)new DataTable(tableName, (Iterable<IDataColumn>)cols))), API.Case((API.Match.Pattern1)Patterns.$Failure((API.Match.Pattern)API.$()), Try::failure)});
    }

    private static Try<Seq<IDataColumn>> validateColumns(Iterable<IDataColumn> columns) {
        return DataTable.validateColumnNames((Seq<IDataColumn>)Stream.ofAll(columns)).flatMap(DataTable::validateColumnDataLength);
    }

    private static Try<Seq<IDataColumn>> validateColumnNames(Seq<IDataColumn> columns) {
        return columns.groupBy(IDataColumn::name).length() != columns.length() ? DataTableException.tryError("Columns contain duplicate names.") : Try.success(columns);
    }

    private static Try<Seq<IDataColumn>> validateColumnDataLength(Seq<IDataColumn> columns) {
        return columns.groupBy(col -> col.data().length()).length() > 1 ? DataTableException.tryError("Columns have different lengths.") : Try.success(columns);
    }
}

