/*
 * Decompiled with CFR 0.152.
 */
package com.github.martincooper.datatable;

import io.vavr.collection.Stream;
import io.vavr.control.Try;
import java.util.Objects;

public class Guard {
    public static void notNull(Object argument, String name) {
        if (argument == null) {
            throw new IllegalArgumentException("Invalid value [NULL] for argument " + name);
        }
    }

    public static <T> void itemsNotNull(Iterable<T> argument, String name) {
        Guard.notNull(argument, name);
        if (!Stream.ofAll(argument).find(Objects::isNull).isEmpty()) {
            throw new IllegalArgumentException("Invalid value [NULL] in collection for argument " + name);
        }
    }

    public static <T> void itemsNotNull(T[] argument, String name) {
        Guard.notNull(argument, name);
        Guard.itemsNotNull(Stream.of((Object[])argument), name);
    }

    public static <T> Try<T> tryNotNull(T argument, String name) {
        return argument == null ? Try.failure((Throwable)new IllegalArgumentException("Invalid value [NULL] for argument " + name)) : Try.success(argument);
    }
}

