/*
 * Decompiled with CFR 0.152.
 */
package com.github.martincooper.datatable.sorting;

import com.github.martincooper.datatable.DataRow;
import com.github.martincooper.datatable.DataTable;
import com.github.martincooper.datatable.DataTableException;
import com.github.martincooper.datatable.DataView;
import com.github.martincooper.datatable.IDataColumn;
import com.github.martincooper.datatable.sorting.DataRowComparator;
import com.github.martincooper.datatable.sorting.SortItem;
import io.vavr.API;
import io.vavr.Patterns;
import io.vavr.collection.Seq;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.util.List;

public class DataSort {
    public static Try<DataView> quickSort(DataTable table, Seq<DataRow> rows, Seq<SortItem> sortItems) {
        return (Try)API.Match(DataSort.validateSortColumns(table, sortItems)).of(new API.Match.Case[]{API.Case((API.Match.Pattern1)Patterns.$Success((API.Match.Pattern)API.$()), cols -> Try.success((Object)DataSort.performQuickSort(table, rows, sortItems))), API.Case((API.Match.Pattern1)Patterns.$Failure((API.Match.Pattern)API.$()), Try::failure)});
    }

    private static DataView performQuickSort(DataTable table, Seq<DataRow> dataRows, Seq<SortItem> sortItems) {
        List rowList = dataRows.toJavaList();
        rowList.sort(new DataRowComparator(sortItems));
        return (DataView)DataView.build(table, rowList).get();
    }

    private static Try<Void> validateSortColumns(DataTable table, Seq<SortItem> sortItems) {
        return DataSort.validateSortColumnIdentity(table, sortItems).flatMap(DataSort::validateColumnsAreComparable);
    }

    private static Try<Seq<IDataColumn>> validateSortColumnIdentity(DataTable table, Seq<SortItem> sortItems) {
        Seq checkCols = sortItems.map(item -> item.getColumn(table));
        return checkCols.find(Try::isFailure).isEmpty() ? Try.success((Object)checkCols.map(Try::get)) : DataTableException.tryError("Column for Sort Item not found.");
    }

    private static Try<Void> validateColumnsAreComparable(Seq<IDataColumn> columns) {
        Option invalidCol = columns.find(col -> !col.IsComparable());
        return invalidCol.isEmpty() ? Try.success(null) : DataTableException.tryError("Column '" + ((IDataColumn)invalidCol.get()).name() + "' doesn't support comparable.");
    }
}

