/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.agcod.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>CancelGiftCardRequest</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelGiftCardRequest extends AgcodRequest implements
        ToCopyableBuilder<CancelGiftCardRequest.Builder, CancelGiftCardRequest> {
    private static final SdkField<String> CREATION_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CancelGiftCardRequest::creationRequestId)).setter(setter(Builder::creationRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationRequestId").build()).build();

    private static final SdkField<String> PARTNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CancelGiftCardRequest::partnerId)).setter(setter(Builder::partnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partnerId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_REQUEST_ID_FIELD,
            PARTNER_ID_FIELD));

    private final String creationRequestId;

    private final String partnerId;

    private CancelGiftCardRequest(BuilderImpl builder) {
        super(builder);
        this.creationRequestId = builder.creationRequestId;
        this.partnerId = builder.partnerId;
    }

    /**
     * <p>
     * A unique identifier for every CreateGiftCard call that results in the creation of a GC. The partner must generate
     * a new value for every Create request (except for retries) To keep this as the globally unique transaction
     * identifier, the partner needs to:
     * <ul>
     * <li>Generate an alphanumeric value that is unique within the partner’s systems. ID may have a maximum of 19
     * alphanumeric characters</li>
     * <li>Creation Request ID must begin with the partnerID.</li>
     * </ul>
     * </p>
     * 
     * @return A unique identifier for every CreateGiftCard call that results in the creation of a GC. The partner must
     *         generate a new value for every Create request (except for retries) To keep this as the globally unique
     *         transaction identifier, the partner needs to:
     *         <ul>
     *         <li>Generate an alphanumeric value that is unique within the partner’s systems. ID may have a maximum of
     *         19 alphanumeric characters</li>
     *         <li>Creation Request ID must begin with the partnerID.</li>
     *         </ul>
     */
    public String creationRequestId() {
        return creationRequestId;
    }

    /**
     * <p>
     * A unique identifier (CASE SENSITIVE, 1st letter is capitalized and the next four are lower case) provided by the
     * Amazon GC team. This value is part of the Payload of every AGCOD Gateway request.
     * </p>
     * 
     * @return A unique identifier (CASE SENSITIVE, 1st letter is capitalized and the next four are lower case) provided
     *         by the Amazon GC team. This value is part of the Payload of every AGCOD Gateway request.
     */
    public String partnerId() {
        return partnerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(creationRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(partnerId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelGiftCardRequest)) {
            return false;
        }
        CancelGiftCardRequest other = (CancelGiftCardRequest) obj;
        return Objects.equals(creationRequestId(), other.creationRequestId()) && Objects.equals(partnerId(), other.partnerId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CancelGiftCardRequest").add("CreationRequestId", creationRequestId())
                .add("PartnerId", partnerId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "creationRequestId":
            return Optional.ofNullable(clazz.cast(creationRequestId()));
        case "partnerId":
            return Optional.ofNullable(clazz.cast(partnerId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelGiftCardRequest, T> g) {
        return obj -> g.apply((CancelGiftCardRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AgcodRequest.Builder, SdkPojo, CopyableBuilder<Builder, CancelGiftCardRequest> {
        /**
         * <p>
         * A unique identifier for every CreateGiftCard call that results in the creation of a GC. The partner must
         * generate a new value for every Create request (except for retries) To keep this as the globally unique
         * transaction identifier, the partner needs to:
         * <ul>
         * <li>Generate an alphanumeric value that is unique within the partner’s systems. ID may have a maximum of 19
         * alphanumeric characters</li>
         * <li>Creation Request ID must begin with the partnerID.</li>
         * </ul>
         * </p>
         * 
         * @param creationRequestId
         *        A unique identifier for every CreateGiftCard call that results in the creation of a GC. The partner
         *        must generate a new value for every Create request (except for retries) To keep this as the globally
         *        unique transaction identifier, the partner needs to:
         *        <ul>
         *        <li>Generate an alphanumeric value that is unique within the partner’s systems. ID may have a maximum
         *        of 19 alphanumeric characters</li>
         *        <li>Creation Request ID must begin with the partnerID.</li>
         *        </ul>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationRequestId(String creationRequestId);

        /**
         * <p>
         * A unique identifier (CASE SENSITIVE, 1st letter is capitalized and the next four are lower case) provided by
         * the Amazon GC team. This value is part of the Payload of every AGCOD Gateway request.
         * </p>
         * 
         * @param partnerId
         *        A unique identifier (CASE SENSITIVE, 1st letter is capitalized and the next four are lower case)
         *        provided by the Amazon GC team. This value is part of the Payload of every AGCOD Gateway request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partnerId(String partnerId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AgcodRequest.BuilderImpl implements Builder {
        private String creationRequestId;

        private String partnerId;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelGiftCardRequest model) {
            super(model);
            creationRequestId(model.creationRequestId);
            partnerId(model.partnerId);
        }

        public final String getCreationRequestId() {
            return creationRequestId;
        }

        @Override
        public final Builder creationRequestId(String creationRequestId) {
            this.creationRequestId = creationRequestId;
            return this;
        }

        public final void setCreationRequestId(String creationRequestId) {
            this.creationRequestId = creationRequestId;
        }

        public final String getPartnerId() {
            return partnerId;
        }

        @Override
        public final Builder partnerId(String partnerId) {
            this.partnerId = partnerId;
            return this;
        }

        public final void setPartnerId(String partnerId) {
            this.partnerId = partnerId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CancelGiftCardRequest build() {
            return new CancelGiftCardRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
