/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.agcod;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.agcod.AgcodClient;
import software.amazon.awssdk.services.agcod.model.AgcodException;
import software.amazon.awssdk.services.agcod.model.CancelGiftCardRequest;
import software.amazon.awssdk.services.agcod.model.CancelGiftCardResponse;
import software.amazon.awssdk.services.agcod.model.CreateGiftCardRequest;
import software.amazon.awssdk.services.agcod.model.CreateGiftCardResponse;
import software.amazon.awssdk.services.agcod.model.GetAvailableFundsRequest;
import software.amazon.awssdk.services.agcod.model.GetAvailableFundsResponse;
import software.amazon.awssdk.services.agcod.model.InternalServerErrorException;
import software.amazon.awssdk.services.agcod.model.PartnerAccessErrorException;
import software.amazon.awssdk.services.agcod.model.PartnerInputErrorException;
import software.amazon.awssdk.services.agcod.model.ResendErrorException;
import software.amazon.awssdk.services.agcod.model.SystemErrorException;
import software.amazon.awssdk.services.agcod.model.UnknownErrorException;
import software.amazon.awssdk.services.agcod.transform.CancelGiftCardRequestMarshaller;
import software.amazon.awssdk.services.agcod.transform.CreateGiftCardRequestMarshaller;
import software.amazon.awssdk.services.agcod.transform.GetAvailableFundsRequestMarshaller;

@SdkInternalApi
final class DefaultAgcodClient
implements AgcodClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultAgcodClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "AGCODService";
    }

    @Override
    public CancelGiftCardResponse cancelGiftCard(CancelGiftCardRequest cancelGiftCardRequest) throws InternalServerErrorException, SystemErrorException, PartnerInputErrorException, PartnerAccessErrorException, ResendErrorException, UnknownErrorException, AwsServiceException, SdkClientException, AgcodException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelGiftCardResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CancelGiftCardResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelGiftCard").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelGiftCardRequest).withMarshaller((Marshaller)new CancelGiftCardRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateGiftCardResponse createGiftCard(CreateGiftCardRequest createGiftCardRequest) throws InternalServerErrorException, SystemErrorException, PartnerInputErrorException, PartnerAccessErrorException, ResendErrorException, UnknownErrorException, AwsServiceException, SdkClientException, AgcodException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGiftCardResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateGiftCardResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGiftCard").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createGiftCardRequest).withMarshaller((Marshaller)new CreateGiftCardRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetAvailableFundsResponse getAvailableFunds(GetAvailableFundsRequest getAvailableFundsRequest) throws InternalServerErrorException, SystemErrorException, PartnerInputErrorException, PartnerAccessErrorException, ResendErrorException, UnknownErrorException, AwsServiceException, SdkClientException, AgcodException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAvailableFundsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetAvailableFundsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAvailableFunds").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAvailableFundsRequest).withMarshaller((Marshaller)new GetAvailableFundsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(AgcodException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").customErrorCodeFieldName("errorCode").registerModeledException(ExceptionMetadata.builder().errorCode("F100").exceptionBuilderSupplier(SystemErrorException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("F200").exceptionBuilderSupplier(PartnerInputErrorException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("F300").exceptionBuilderSupplier(PartnerAccessErrorException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("F500").exceptionBuilderSupplier(UnknownErrorException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("F400").exceptionBuilderSupplier(ResendErrorException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerError").exceptionBuilderSupplier(InternalServerErrorException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    public void close() {
        this.clientHandler.close();
    }
}

