/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.agcod.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.agcod.model.AgcodException;
import software.amazon.awssdk.services.agcod.model.GiftCardResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PartnerInputErrorException
extends AgcodException
implements ToCopyableBuilder<Builder, PartnerInputErrorException> {
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PartnerInputErrorException.getter(PartnerInputErrorException::errorCode)).setter(PartnerInputErrorException.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()}).build();
    private static final SdkField<String> ERROR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PartnerInputErrorException.getter(PartnerInputErrorException::errorType)).setter(PartnerInputErrorException.setter(Builder::errorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorType").build()}).build();
    private static final SdkField<GiftCardResponse> AGCOD_RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PartnerInputErrorException.getter(PartnerInputErrorException::agcodResponse)).setter(PartnerInputErrorException.setter(Builder::agcodResponse)).constructor(GiftCardResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agcodResponse").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_CODE_FIELD, ERROR_TYPE_FIELD, AGCOD_RESPONSE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String errorCode;
    private final String errorType;
    private final GiftCardResponse agcodResponse;

    private PartnerInputErrorException(BuilderImpl builder) {
        super(builder);
        this.errorCode = builder.errorCode;
        this.errorType = builder.errorType;
        this.agcodResponse = builder.agcodResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public String errorCode() {
        return this.errorCode;
    }

    public String errorType() {
        return this.errorType;
    }

    public GiftCardResponse agcodResponse() {
        return this.agcodResponse;
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PartnerInputErrorException, T> g) {
        return obj -> g.apply((PartnerInputErrorException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AgcodException.BuilderImpl
    implements Builder {
        private String errorCode;
        private String errorType;
        private GiftCardResponse agcodResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(PartnerInputErrorException model) {
            super(model);
            this.errorCode(model.errorCode);
            this.errorType(model.errorType);
            this.agcodResponse(model.agcodResponse);
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorType() {
            return this.errorType;
        }

        @Override
        public final Builder errorType(String errorType) {
            this.errorType = errorType;
            return this;
        }

        public final void setErrorType(String errorType) {
            this.errorType = errorType;
        }

        public final GiftCardResponse.Builder getAgcodResponse() {
            return this.agcodResponse != null ? this.agcodResponse.toBuilder() : null;
        }

        @Override
        public final Builder agcodResponse(GiftCardResponse agcodResponse) {
            this.agcodResponse = agcodResponse;
            return this;
        }

        public final void setAgcodResponse(GiftCardResponse.BuilderImpl agcodResponse) {
            this.agcodResponse = agcodResponse != null ? agcodResponse.build() : null;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public PartnerInputErrorException build() {
            return new PartnerInputErrorException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PartnerInputErrorException>,
    AgcodException.Builder {
        public Builder errorCode(String var1);

        public Builder errorType(String var1);

        public Builder agcodResponse(GiftCardResponse var1);

        default public Builder agcodResponse(Consumer<GiftCardResponse.Builder> agcodResponse) {
            return this.agcodResponse((GiftCardResponse)((GiftCardResponse.Builder)GiftCardResponse.builder().applyMutation(agcodResponse)).build());
        }

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);
    }
}

