/*
 * libxjava -- utility library for cross-Java-platform development
 *             Lib-Cross-Java CLDC
 *
 * Copyright (c) 2010 Marcel Patzlaff (marcel.patzlaff@gmail.com)
 *
 * This library is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.github.libxjava.lang;

import java.io.InputStream;

/**
 * @author Marcel Patzlaff
 * @version libxjava-cldc - 0.2
 */
public class SimpleClassLoader implements IClassLoader {
    public InputStream getResourceAsStream(String name) {
        if(!name.startsWith("/")) {
            name= "/" + name;
        }
        
        return getClass().getResourceAsStream(name);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return Class.forName(name);
    }
}
