/*
 * Decompiled with CFR 0.152.
 */
package com.github.libxjava.io;

import com.github.libxjava.io.BaseX;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Base85
extends BaseX {
    private static final byte[] ENCODABET;
    private static final byte[] DECODABET;
    private static final long[] FACTORS;

    protected void internalDecode(InputStream in, OutputStream out) throws IOException {
        int e;
        int b;
        int factor = 5;
        long sum = 0L;
        while ((b = in.read()) >= 0) {
            sum += (long)DECODABET[b] * FACTORS[--factor];
            if (factor != 0) continue;
            for (e = 24; e >= 0; e -= 8) {
                out.write((int)(sum >>> e & 0xFFL));
            }
            sum = 0L;
            factor = 5;
        }
        if (factor < 5) {
            sum /= FACTORS[factor];
            for (e = (3 - factor) * 8; e >= 0; e -= 8) {
                out.write((int)(sum >>> e & 0xFFL));
            }
        }
    }

    protected void internalEncode(InputStream in, OutputStream out) throws IOException {
        int e;
        int b;
        int bytes = 0;
        long sum = 0L;
        while ((b = in.read()) >= 0) {
            sum = sum << 8 | (long)b;
            if (++bytes != 4) continue;
            for (e = 4; e >= 0; --e) {
                out.write(ENCODABET[(int)(sum / FACTORS[e])]);
                sum %= FACTORS[e];
            }
            sum = 0L;
            bytes = 0;
        }
        if (bytes > 0) {
            for (e = bytes; e >= 0; --e) {
                out.write(ENCODABET[(int)(sum / FACTORS[e])]);
                sum %= FACTORS[e];
            }
        }
    }

    static {
        int i;
        FACTORS = new long[]{1L, 85L, 7225L, 614125L, 52200625L};
        ENCODABET = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 33, 35, 36, 37, 38, 40, 41, 42, 43, 45, 59, 60, 61, 62, 63, 64, 94, 95, 96, 123, 124, 125, 126};
        DECODABET = new byte[256];
        for (i = 0; i < DECODABET.length; ++i) {
            Base85.DECODABET[i] = -1;
        }
        for (i = 0; i < ENCODABET.length; ++i) {
            Base85.DECODABET[Base85.ENCODABET[i] & 0xFF] = (byte)i;
        }
    }
}

