/*
 * Decompiled with CFR 0.152.
 */
package com.github.libxjava.util;

public class IntHashMap {
    private static final int LOAD_PERCENT_FACTOR = 75;
    private Entry[] _table;
    private int _count;
    private int _threshold;

    public IntHashMap() {
        this(20);
    }

    public IntHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this._table = new Entry[initialCapacity];
        this._threshold = initialCapacity * 75 / 100;
    }

    public void clear() {
        Entry[] tab = this._table;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
        this._count = 0;
    }

    public boolean containsKey(int key) {
        return this.getEntry(key) != null;
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            Entry[] tab = this._table;
            for (int i = 0; i < tab.length; ++i) {
                Entry e = tab[i];
                while (e != null) {
                    if (e.value == null) {
                        return true;
                    }
                    e = e.next;
                }
            }
        } else {
            Entry[] tab = this._table;
            for (int i = 0; i < tab.length; ++i) {
                Entry e = tab[i];
                while (e != null) {
                    if (value.equals(e.value)) {
                        return true;
                    }
                    e = e.next;
                }
            }
        }
        return false;
    }

    public Object[] elements() {
        Object[] result = new Object[this._count];
        Entry entry = null;
        int e = 0;
        for (int i = 0; i < this._count; ++i) {
            while (entry == null) {
                entry = this._table[e++];
            }
            result[i] = entry.value;
            entry = entry.next;
        }
        return result;
    }

    public Object get(int key) {
        Entry e = this.getEntry(key);
        return e != null ? e.value : null;
    }

    public boolean isEmpty() {
        return this._count == 0;
    }

    public int[] keys() {
        int[] result = new int[this._count];
        Entry entry = null;
        int e = 0;
        for (int i = 0; i < this._count; ++i) {
            while (entry == null) {
                entry = this._table[e++];
            }
            result[i] = entry.key;
            entry = entry.next;
        }
        return result;
    }

    public Object put(int key, Object value) {
        Entry[] tab = this._table;
        int index = (key & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.key == key) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        e = this._table[index];
        this._table[index] = new Entry(key, value, e);
        if (this._count++ >= this._threshold) {
            this.rehash();
        }
        return null;
    }

    public Object remove(int key) {
        Entry[] tab = this._table;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        Entry prev = null;
        while (e != null) {
            if (e.key == key) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this._count;
                return e.value;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public int size() {
        return this._count;
    }

    private Entry getEntry(int key) {
        Entry[] tab = this._table;
        int index = (key & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.key == key) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    private void rehash() {
        int oldCapacity = this._table.length;
        Entry[] oldTable = this._table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newTable = new Entry[newCapacity];
        this._threshold = newCapacity * 75 / 100;
        this._table = newTable;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldTable[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index = (e.key & Integer.MAX_VALUE) % newCapacity;
                e.next = newTable[index];
                newTable[index] = e;
            }
        }
    }

    private static final class Entry {
        int key;
        Object value;
        Entry next;

        Entry(int key, Object value, Entry next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }
    }
}

