/*
 * Decompiled with CFR 0.152.
 */
package com.github.libxjava.concurrent;

import com.github.libxjava.concurrent.IThreadFactory;
import com.github.libxjava.concurrent.TaskFuture;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduledTaskExecutor {
    private final ScheduledThreadPoolExecutor _executorImpl;

    private static final TaskFuture unwrapTaskFuture(Future<?> future) {
        FutureWrapper wrapper = (FutureWrapper)future;
        return wrapper.tf;
    }

    public ScheduledTaskExecutor(int initialPoolSize, int maxPoolSize, long keepAliveTimeInMillis, IThreadFactory threadFactory) {
        this._executorImpl = new ScheduledThreadPoolExecutorExtender(maxPoolSize, threadFactory);
        this._executorImpl.setKeepAliveTime(keepAliveTimeInMillis, TimeUnit.MILLISECONDS);
        this._executorImpl.allowCoreThreadTimeOut(true);
        for (int i = 0; i < initialPoolSize; ++i) {
            this._executorImpl.prestartCoreThread();
        }
    }

    public TaskFuture submit(Runnable target) {
        return ScheduledTaskExecutor.unwrapTaskFuture(this._executorImpl.submit(target));
    }

    public TaskFuture schedule(Runnable target, long delayInMillis) {
        return ScheduledTaskExecutor.unwrapTaskFuture(this._executorImpl.schedule(target, delayInMillis, TimeUnit.MILLISECONDS));
    }

    public TaskFuture scheduleAtFixedRate(Runnable target, long delayInMillis, long periodInMillis) {
        return ScheduledTaskExecutor.unwrapTaskFuture(this._executorImpl.scheduleAtFixedRate(target, delayInMillis, periodInMillis, TimeUnit.MILLISECONDS));
    }

    protected void beforeExecute(Thread workThread, TaskFuture task) {
    }

    protected void afterExecute(TaskFuture task, Throwable t) {
        task.future = null;
    }

    protected TaskFuture createTaskFuture(Object target) {
        return new TaskFuture();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ScheduledThreadPoolExecutorExtender
    extends ScheduledThreadPoolExecutor {
        protected ScheduledThreadPoolExecutorExtender(int corePoolSize, IThreadFactory threadFactory) {
            super(corePoolSize, threadFactory);
        }

        @Override
        protected final void afterExecute(Runnable r, Throwable t) {
            ScheduledTaskExecutor.this.afterExecute(((FutureWrapper)r).tf, t);
            super.afterExecute(r, t);
        }

        @Override
        protected final void beforeExecute(Thread t, Runnable r) {
            ScheduledTaskExecutor.this.beforeExecute(t, ((FutureWrapper)r).tf);
            super.beforeExecute(t, r);
        }

        @Override
        protected final <V> RunnableScheduledFuture<V> decorateTask(Callable<V> callable, RunnableScheduledFuture<V> task) {
            return new FutureWrapper<V>(ScheduledTaskExecutor.this.createTaskFuture(callable), task);
        }

        @Override
        protected final <V> RunnableScheduledFuture<V> decorateTask(Runnable runnable, RunnableScheduledFuture<V> task) {
            return new FutureWrapper<V>(ScheduledTaskExecutor.this.createTaskFuture(runnable), task);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FutureWrapper<V>
    implements RunnableScheduledFuture<V> {
        protected final TaskFuture tf;
        protected final RunnableScheduledFuture<V> of;

        protected FutureWrapper(TaskFuture tf, RunnableScheduledFuture<V> of) {
            this.tf = tf;
            this.of = of;
            tf.future = of;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.of.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.of.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.of.isDone();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return this.of.get();
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.of.get(timeout, unit);
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return this.of.getDelay(unit);
        }

        @Override
        public int compareTo(Delayed o) {
            return this.of.compareTo(o);
        }

        @Override
        public void run() {
            this.of.run();
        }

        @Override
        public boolean isPeriodic() {
            return this.of.isPeriodic();
        }
    }
}

