/*
 * Decompiled with CFR 0.152.
 */
package com.github.libxjava.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;

public final class ByteArrayBuffer {
    private final Reader _reader;
    private final Writer _writer;
    private final byte[] _buffer;
    private int _writePointer;
    private int _readPointer;
    private int _markPointer;
    private int _markLimit;
    private boolean _readBehind;
    private int _lastFrameEnd;
    private boolean _dropUntilFlush;
    private String _readErrorMessage;
    private long _frameWriteTimeout;
    private long _frameReadTimeout;
    private boolean _frameEndRead;
    private boolean _endOfStream;

    public ByteArrayBuffer(int bufSize) {
        this(bufSize, 1L, 1L);
    }

    public ByteArrayBuffer(int bufSize, long frameReadTimeout, long frameWriteTimeout) {
        this._buffer = new byte[bufSize];
        this._reader = new Reader();
        this._writer = new Writer();
        this._readPointer = 0;
        this._writePointer = 0;
        this._markPointer = -1;
        this._markLimit = -1;
        this._readBehind = false;
        this._dropUntilFlush = false;
        this._lastFrameEnd = -1;
        this._readErrorMessage = null;
        this._frameEndRead = false;
        this._endOfStream = false;
        this._frameReadTimeout = frameReadTimeout;
        this._frameWriteTimeout = frameWriteTimeout;
    }

    public int capacity() {
        return this._buffer.length;
    }

    public Reader getReader() {
        return this._reader;
    }

    public Writer getWriter() {
        return this._writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalWrite(byte[] b, int off, int len) throws IOException {
        if (this._dropUntilFlush) {
            return;
        }
        long start = System.currentTimeMillis();
        byte[] byArray = this._buffer;
        synchronized (this._buffer) {
            if (this._endOfStream) {
                throw new IOException("buffer is not ready yet");
            }
            while (len > 0) {
                int numBytes;
                int written;
                int place = this.internalSpace();
                if (place == 0) {
                    long timeoutLeft = this._frameWriteTimeout - (System.currentTimeMillis() - start);
                    if (timeoutLeft > 0L) {
                        try {
                            this._buffer.wait(timeoutLeft);
                            continue;
                        }
                        catch (InterruptedException e) {
                            throw new InterruptedIOException(e.getMessage());
                        }
                    }
                    this._dropUntilFlush = true;
                    if (this._lastFrameEnd >= 0) {
                        this._writePointer = this.getValidOffset(this._lastFrameEnd + 1);
                    } else {
                        this._writePointer = 0;
                        this._readPointer = 0;
                        this._readErrorMessage = "buffer overflow";
                    }
                    throw new IOException("buffer overflow: " + len + " vs " + place);
                }
                for (numBytes = 0; place > numBytes && len > 0; len -= written, numBytes += written) {
                    written = this.internalWrite0(b, off, len);
                    off += written;
                }
                if (numBytes <= 0) continue;
                this._buffer.notify();
            }
            // ** MonitorExit[var6_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalCloseWriter() {
        byte[] byArray = this._buffer;
        synchronized (this._buffer) {
            this.internalMarkComplete();
            this._endOfStream = true;
            this._buffer.notify();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalMarkComplete() {
        byte[] byArray = this._buffer;
        synchronized (this._buffer) {
            if (this._dropUntilFlush) {
                this._dropUntilFlush = false;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (this._writePointer == this._readPointer && !this._readBehind) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this._lastFrameEnd = this.getValidOffset(this._writePointer - 1);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalMarkIncomplete() {
        byte[] byArray = this._buffer;
        synchronized (this._buffer) {
            if (this._lastFrameEnd >= 0) {
                this._writePointer = this.getValidOffset(this._lastFrameEnd + 1);
            } else {
                this._readErrorMessage = "missing content";
                this._writePointer = 0;
                this._readPointer = 0;
                this._buffer.notify();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int internalRead(byte[] b, int off, int len) throws IOException {
        byte[] byArray = this._buffer;
        synchronized (this._buffer) {
            int numBytes;
            int read;
            int available;
            block15: {
                boolean canWait = true;
                while (true) {
                    if (this._readErrorMessage != null) {
                        try {
                            throw new IOException(this._readErrorMessage);
                        }
                        catch (Throwable throwable) {
                            this._readErrorMessage = null;
                            throw throwable;
                        }
                    }
                    available = this.internalAvailable();
                    if (available != 0) break block15;
                    if (this._endOfStream) {
                        this._endOfStream = false;
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        return -1;
                    }
                    if (!canWait && !this._frameEndRead) break;
                    try {
                        this._buffer.wait(this._frameEndRead ? 0L : this._frameReadTimeout);
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException(e.getMessage());
                    }
                    canWait = false;
                }
                throw new IOException("timeout");
            }
            this._frameEndRead = false;
            for (numBytes = 0; !this._frameEndRead && available > numBytes && len > 0; len -= read, numBytes += read) {
                read = this.internalRead0(b, off, len);
                off += read;
            }
            if (this._markPointer >= 0) {
                this._markLimit -= numBytes;
                if (this._markLimit < 0) {
                    this._markLimit = -1;
                    this._markPointer = -1;
                }
            } else if (numBytes > 0) {
                this._buffer.notify();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return numBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int internalAvailable() {
        byte[] byArray = this._buffer;
        synchronized (this._buffer) {
            if (this._readPointer < this._writePointer) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this._writePointer - this._readPointer;
            }
            if (this._readPointer > this._writePointer || this._readBehind) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this._buffer.length - this._readPointer + this._writePointer;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalMark(int readlimit) {
        byte[] byArray = this._buffer;
        synchronized (this._buffer) {
            if (readlimit >= this._buffer.length) {
                throw new IllegalArgumentException("readlimit exceeds buffer size");
            }
            this._markLimit = readlimit;
            this._markPointer = this._readPointer;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    void internalReset() throws IOException {
        byte[] byArray = this._buffer;
        synchronized (this._buffer) {
            if (this._markPointer >= 0) {
                if (this._markPointer > this._readPointer) {
                    this._readBehind = true;
                }
                this._readPointer = this._markPointer;
                this._markPointer = -1;
                this._markLimit = -1;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            throw new IOException("buffer was not marked before");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int internalSpace() {
        byte[] byArray = this._buffer;
        synchronized (this._buffer) {
            int consumedPointer;
            int n = consumedPointer = this._markPointer >= 0 ? this._markPointer : this._readPointer;
            if (consumedPointer < this._writePointer) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this._buffer.length - this._writePointer + consumedPointer;
            }
            if (consumedPointer > this._writePointer || consumedPointer > this._readPointer || this._readBehind) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return consumedPointer - this._writePointer;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this._buffer.length;
        }
    }

    private int getValidOffset(int offset) {
        return (offset %= this._buffer.length) < 0 ? this._buffer.length + offset : offset;
    }

    private int internalWrite0(byte[] b, int off, int len) {
        int toWrite;
        int consumedPointer = this._markPointer >= 0 ? this._markPointer : this._readPointer;
        int maxToWrite = this._writePointer < consumedPointer ? consumedPointer - this._writePointer : this._buffer.length - this._writePointer;
        int n = toWrite = maxToWrite > len ? len : maxToWrite;
        if (toWrite > 0) {
            System.arraycopy(b, off, this._buffer, this._writePointer, toWrite);
            this._writePointer = this.getValidOffset(this._writePointer + toWrite);
            if (this._writePointer == 0) {
                this._readBehind = true;
            }
        }
        return toWrite;
    }

    private int internalRead0(byte[] b, int off, int len) {
        int toRead;
        int maxToRead = this._readPointer < this._writePointer ? this._writePointer - this._readPointer : this._buffer.length - this._readPointer;
        boolean checkEndOfLastFrameReached = false;
        if (this._readPointer <= this._lastFrameEnd) {
            maxToRead = this._lastFrameEnd - this._readPointer + 1;
            checkEndOfLastFrameReached = true;
        }
        int n = toRead = maxToRead > len ? len : maxToRead;
        if (toRead > 0) {
            System.arraycopy(this._buffer, this._readPointer, b, off, toRead);
            this._readPointer = this.getValidOffset(this._readPointer + toRead);
            if (this._readPointer == 0) {
                this._readBehind = false;
            }
        }
        if (checkEndOfLastFrameReached && toRead == maxToRead) {
            this._lastFrameEnd = -1;
            this._frameEndRead = true;
        }
        return toRead;
    }

    public final class Writer
    extends OutputStream {
        private final byte[] _oneByte = new byte[1];

        public int space() {
            return ByteArrayBuffer.this.internalSpace();
        }

        public void close() {
            ByteArrayBuffer.this.internalCloseWriter();
        }

        public void flush() {
            ByteArrayBuffer.this.internalMarkComplete();
        }

        public void write(byte[] b, int off, int len) throws IOException {
            ByteArrayBuffer.this.internalWrite(b, off, len);
        }

        public void write(byte[] b) throws IOException {
            ByteArrayBuffer.this.internalWrite(b, 0, b.length);
        }

        public void write(int v) throws IOException {
            this._oneByte[0] = (byte)v;
            ByteArrayBuffer.this.internalWrite(this._oneByte, 0, 1);
        }

        public void markComplete() {
            ByteArrayBuffer.this.internalMarkComplete();
        }

        public void markIncomplete() {
            ByteArrayBuffer.this.internalMarkIncomplete();
        }
    }

    public final class Reader
    extends InputStream {
        private final byte[] _oneByte = new byte[1];

        public int available() {
            return ByteArrayBuffer.this.internalAvailable();
        }

        public synchronized void mark(int readlimit) {
            ByteArrayBuffer.this.internalMark(readlimit);
        }

        public boolean markSupported() {
            return true;
        }

        public synchronized void reset() throws IOException {
            ByteArrayBuffer.this.internalReset();
        }

        public int read() throws IOException {
            ByteArrayBuffer.this.internalRead(this._oneByte, 0, 1);
            return this._oneByte[0] & 0xFF;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return ByteArrayBuffer.this.internalRead(b, off, len);
        }

        public int read(byte[] b) throws IOException {
            return ByteArrayBuffer.this.internalRead(b, 0, b.length);
        }
    }
}

