/*
 * Decompiled with CFR 0.152.
 */
package de.mrapp.util;

import java.io.File;
import java.lang.reflect.Constructor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Condition {
    private Condition() {
    }

    private static void throwException(@Nullable String exceptionMessage, @NotNull Class<? extends RuntimeException> exceptionClass) {
        RuntimeException exception;
        try {
            Constructor<? extends RuntimeException> constructor = exceptionClass.getConstructor(String.class);
            exception = constructor.newInstance(exceptionMessage);
        }
        catch (Exception e) {
            exception = new RuntimeException(exceptionMessage);
        }
        throw exception;
    }

    public static void ensureTrue(boolean expression, @Nullable String exceptionMessage) {
        Condition.ensureTrue(expression, exceptionMessage, IllegalArgumentException.class);
    }

    public static void ensureTrue(boolean expression, @Nullable String exceptionMessage, @NotNull Class<? extends RuntimeException> exceptionClass) {
        if (!expression) {
            Condition.throwException(exceptionMessage, exceptionClass);
        }
    }

    public static void ensureFalse(boolean expression, @Nullable String exceptionMessage) {
        Condition.ensureFalse(expression, exceptionMessage, IllegalArgumentException.class);
    }

    public static void ensureFalse(boolean expression, @Nullable String exceptionMessage, @NotNull Class<? extends RuntimeException> exceptionClass) {
        if (expression) {
            Condition.throwException(exceptionMessage, exceptionClass);
        }
    }

    public static void ensureEqual(Object object1, Object object2, @Nullable String exceptionMessage) {
        Condition.ensureEqual(object1, object2, exceptionMessage, IllegalArgumentException.class);
    }

    public static void ensureEqual(Object object1, Object object2, @Nullable String exceptionMessage, @NotNull Class<? extends RuntimeException> exceptionClass) {
        if (object1 == null && object2 != null || object1 != null && !object1.equals(object2)) {
            Condition.throwException(exceptionMessage, exceptionClass);
        }
    }

    public static void ensureNotEqual(Object object1, Object object2, @Nullable String exceptionMessage) {
        Condition.ensureNotEqual(object1, object2, exceptionMessage, IllegalArgumentException.class);
    }

    public static void ensureNotEqual(Object object1, Object object2, @Nullable String exceptionMessage, @NotNull Class<? extends RuntimeException> exceptionClass) {
        if (object1 == null && object2 == null || object1 != null && object1.equals(object2)) {
            Condition.throwException(exceptionMessage, exceptionClass);
        }
    }

    public static void ensureNotNull(Object object, @Nullable String exceptionMessage) {
        Condition.ensureNotNull(object, exceptionMessage, IllegalArgumentException.class);
    }

    public static void ensureNotNull(Object object, @Nullable String exceptionMessage, @NotNull Class<? extends RuntimeException> exceptionClass) {
        if (object == null) {
            Condition.throwException(exceptionMessage, exceptionClass);
        }
    }

    public static void ensureNotEmpty(CharSequence text, @Nullable String exceptionMessage) {
        Condition.ensureNotEmpty(text, exceptionMessage, IllegalArgumentException.class);
    }

    public static void ensureNotEmpty(CharSequence text, @Nullable String exceptionMessage, @NotNull Class<? extends RuntimeException> exceptionClass) {
        if (text == null || text.length() == 0) {
            Condition.throwException(exceptionMessage, exceptionClass);
        }
    }

    public static void ensureAtLeast(short value, short referenceValue, @Nullable String exceptionMessage) {
        Condition.ensureAtLeast(value, referenceValue, exceptionMessage, IllegalArgumentException.class);
    }

    public static void ensureAtLeast(short value, short referenceValue, @Nullable String exceptionMessage, @NotNull Class<? extends RuntimeException> exceptionClass) {
        if (value < referenceValue) {
            Condition.throwException(exceptionMessage, exceptionClass);
        }
    }

    public static void ensureAtLeast(int value, int referenceValue, @Nullable String exceptionMessage) {
        Condition.ensureAtLeast(value, referenceValue, exceptionMessage, IllegalArgumentException.class);
    }

    public static void ensureAtLeast(int value, int referenceValue, @Nullable String exceptionMessage, @NotNull Class<? extends RuntimeException> exceptionClass) {
        if (value < referenceValue) {
            Condition.throwException(exceptionMessage, exceptionClass);
        }
    }

    public static void ensureAtLeast(long value, long referenceValue, @Nullable String exceptionMessage) {
        Condition.ensureAtLeast(value, referenceValue, exceptionMessage, IllegalArgumentException.class);
    }

    public static void ensureAtLeast(long value, long referenceValue, @Nullable String exceptionMessage, @NotNull Class<? extends RuntimeException> exceptionClass) {
        if (value < referenceValue) {
            Condition.throwException(exceptionMessage, exceptionClass);
        }
    }

    public static void ensureAtLeast(float value, float referenceValue, @Nullable String exceptionMessage) {
        Condition.ensureAtLeast(value, referenceValue, exceptionMessage, IllegalArgumentException.class);
    }

    public static void ensureAtLeast(float value, float referenceValue, @Nullable String exceptionMessage, @NotNull Class<? extends RuntimeException> exceptionClass) {
        if (value < referenceValue) {
            Condition.throwException(exceptionMessage, exceptionClass);
        }
    }

    public static void ensureAtLeast(double value, double referenceValue, @Nullable String exceptionMessage) {
        Condition.ensureAtLeast(value, referenceValue, exceptionMessage, IllegalArgumentException.class);
    }

    public static void ensureAtLeast(double value, double referenceValue, @Nullable String exceptionMessage, @NotNull Class<? extends RuntimeException> exceptionClass) {
        if (value < referenceValue) {
            Condition.throwException(exceptionMessage, exceptionClass);
        }
    }

    public static void ensureAtMaximum(short value, short referenceValue, @Nullable String exceptionMessage) {
        Condition.ensureAtMaximum(value, referenceValue, exceptionMessage, IllegalArgumentException.class);
    }

    public static void ensureAtMaximum(short value, short referenceValue, @Nullable String exceptionMessage, @NotNull Class<? extends RuntimeException> exceptionClass) {
        if (value > referenceValue) {
            Condition.throwException(exceptionMessage, exceptionClass);
        }
    }

    public static void ensureAtMaximum(int value, int referenceValue, @Nullable String exceptionMessage) {
        Condition.ensureAtMaximum(value, referenceValue, exceptionMessage, IllegalArgumentException.class);
    }

    public static void ensureAtMaximum(int value, int referenceValue, @Nullable String exceptionMessage, @NotNull Class<? extends RuntimeException> exceptionClass) {
        if (value > referenceValue) {
            Condition.throwException(exceptionMessage, exceptionClass);
        }
    }

    public static void ensureAtMaximum(long value, long referenceValue, @Nullable String exceptionMessage) {
        Condition.ensureAtMaximum(value, referenceValue, exceptionMessage, IllegalArgumentException.class);
    }

    public static void ensureAtMaximum(long value, long referenceValue, @Nullable String exceptionMessage, @NotNull Class<? extends RuntimeException> exceptionClass) {
        if (value > referenceValue) {
            Condition.throwException(exceptionMessage, exceptionClass);
        }
    }

    public static void ensureAtMaximum(float value, float referenceValue, @Nullable String exceptionMessage) {
        Condition.ensureAtMaximum(value, referenceValue, exceptionMessage, IllegalArgumentException.class);
    }

    public static void ensureAtMaximum(float value, float referenceValue, @Nullable String exceptionMessage, @NotNull Class<? extends RuntimeException> exceptionClass) {
        if (value > referenceValue) {
            Condition.throwException(exceptionMessage, exceptionClass);
        }
    }

    public static void ensureAtMaximum(double value, double referenceValue, @Nullable String exceptionMessage) {
        Condition.ensureAtMaximum(value, referenceValue, exceptionMessage, IllegalArgumentException.class);
    }

    public static void ensureAtMaximum(double value, double referenceValue, @Nullable String exceptionMessage, @NotNull Class<? extends RuntimeException> exceptionClass) {
        if (value > referenceValue) {
            Condition.throwException(exceptionMessage, exceptionClass);
        }
    }

    public static void ensureGreater(short value, short referenceValue, @Nullable String exceptionMessage) {
        Condition.ensureGreater(value, referenceValue, exceptionMessage, IllegalArgumentException.class);
    }

    public static void ensureGreater(short value, short referenceValue, @Nullable String exceptionMessage, @NotNull Class<? extends RuntimeException> exceptionClass) {
        if (value <= referenceValue) {
            Condition.throwException(exceptionMessage, exceptionClass);
        }
    }

    public static void ensureGreater(int value, int referenceValue, @Nullable String exceptionMessage) {
        Condition.ensureGreater(value, referenceValue, exceptionMessage, IllegalArgumentException.class);
    }

    public static void ensureGreater(int value, int referenceValue, @Nullable String exceptionMessage, @NotNull Class<? extends RuntimeException> exceptionClass) {
        if (value <= referenceValue) {
            Condition.throwException(exceptionMessage, exceptionClass);
        }
    }

    public static void ensureGreater(long value, long referenceValue, @Nullable String exceptionMessage) {
        Condition.ensureGreater(value, referenceValue, exceptionMessage, IllegalArgumentException.class);
    }

    public static void ensureGreater(long value, long referenceValue, @Nullable String exceptionMessage, @NotNull Class<? extends RuntimeException> exceptionClass) {
        if (value <= referenceValue) {
            Condition.throwException(exceptionMessage, exceptionClass);
        }
    }

    public static void ensureGreater(float value, float referenceValue, @Nullable String exceptionMessage) {
        Condition.ensureGreater(value, referenceValue, exceptionMessage, IllegalArgumentException.class);
    }

    public static void ensureGreater(float value, float referenceValue, @Nullable String exceptionMessage, @NotNull Class<? extends RuntimeException> exceptionClass) {
        if (value <= referenceValue) {
            Condition.throwException(exceptionMessage, exceptionClass);
        }
    }

    public static void ensureGreater(double value, double referenceValue, @Nullable String exceptionMessage) {
        Condition.ensureGreater(value, referenceValue, exceptionMessage, IllegalArgumentException.class);
    }

    public static void ensureGreater(double value, double referenceValue, @Nullable String exceptionMessage, @NotNull Class<? extends RuntimeException> exceptionClass) {
        if (value <= referenceValue) {
            Condition.throwException(exceptionMessage, exceptionClass);
        }
    }

    public static void ensureSmaller(short value, short referenceValue, @Nullable String exceptionMessage) {
        Condition.ensureSmaller(value, referenceValue, exceptionMessage, IllegalArgumentException.class);
    }

    public static void ensureSmaller(short value, short referenceValue, @Nullable String exceptionMessage, @NotNull Class<? extends RuntimeException> exceptionClass) {
        if (value >= referenceValue) {
            Condition.throwException(exceptionMessage, exceptionClass);
        }
    }

    public static void ensureSmaller(int value, int referenceValue, @Nullable String exceptionMessage) {
        Condition.ensureSmaller(value, referenceValue, exceptionMessage, IllegalArgumentException.class);
    }

    public static void ensureSmaller(int value, int referenceValue, @Nullable String exceptionMessage, @NotNull Class<? extends RuntimeException> exceptionClass) {
        if (value >= referenceValue) {
            Condition.throwException(exceptionMessage, exceptionClass);
        }
    }

    public static void ensureSmaller(long value, long referenceValue, @Nullable String exceptionMessage) {
        Condition.ensureSmaller(value, referenceValue, exceptionMessage, IllegalArgumentException.class);
    }

    public static void ensureSmaller(long value, long referenceValue, @Nullable String exceptionMessage, @NotNull Class<? extends RuntimeException> exceptionClass) {
        if (value >= referenceValue) {
            Condition.throwException(exceptionMessage, exceptionClass);
        }
    }

    public static void ensureSmaller(float value, float referenceValue, @Nullable String exceptionMessage) {
        Condition.ensureSmaller(value, referenceValue, exceptionMessage, IllegalArgumentException.class);
    }

    public static void ensureSmaller(float value, float referenceValue, @Nullable String exceptionMessage, @NotNull Class<? extends RuntimeException> exceptionClass) {
        if (value >= referenceValue) {
            Condition.throwException(exceptionMessage, exceptionClass);
        }
    }

    public static void ensureSmaller(double value, double referenceValue, @Nullable String exceptionMessage) {
        Condition.ensureSmaller(value, referenceValue, exceptionMessage, IllegalArgumentException.class);
    }

    public static void ensureSmaller(double value, double referenceValue, @Nullable String exceptionMessage, @NotNull Class<? extends RuntimeException> exceptionClass) {
        if (value >= referenceValue) {
            Condition.throwException(exceptionMessage, exceptionClass);
        }
    }

    public static void ensureNotEmpty(Iterable<?> iterable, @Nullable String exceptionMessage) {
        Condition.ensureNotEmpty(iterable, exceptionMessage, IllegalArgumentException.class);
    }

    public static void ensureNotEmpty(Iterable<?> iterable, @Nullable String exceptionMessage, @NotNull Class<? extends RuntimeException> exceptionClass) {
        if (!iterable.iterator().hasNext()) {
            Condition.throwException(exceptionMessage, exceptionClass);
        }
    }

    public static void ensureFileExists(File file, String exceptionMessage) {
        Condition.ensureFileExists(file, exceptionMessage, IllegalArgumentException.class);
    }

    public static void ensureFileExists(@NotNull File file, @Nullable String exceptionMessage, @NotNull Class<? extends RuntimeException> exceptionClass) {
        if (!file.exists()) {
            Condition.throwException(exceptionMessage, exceptionClass);
        }
    }

    public static void ensureFileIsDirectory(@NotNull File file, @Nullable String exceptionMessage) {
        Condition.ensureFileIsDirectory(file, exceptionMessage, IllegalArgumentException.class);
    }

    public static void ensureFileIsDirectory(@NotNull File file, @Nullable String exceptionMessage, @NotNull Class<? extends RuntimeException> exceptionClass) {
        if (!file.isDirectory()) {
            Condition.throwException(exceptionMessage, exceptionClass);
        }
    }

    public static void ensureFileIsNoDirectory(@NotNull File file, @Nullable String exceptionMessage) {
        Condition.ensureFileIsNoDirectory(file, exceptionMessage, IllegalArgumentException.class);
    }

    public static void ensureFileIsNoDirectory(@NotNull File file, @Nullable String exceptionMessage, @NotNull Class<? extends RuntimeException> exceptionClass) {
        if (!file.isFile()) {
            Condition.throwException(exceptionMessage, exceptionClass);
        }
    }
}

