/*
 * Decompiled with CFR 0.152.
 */
package de.mrapp.util;

import de.mrapp.util.Condition;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class FileUtil {
    private static void mkdir(@NotNull File directory, boolean createParents) throws IOException {
        boolean result;
        Condition.ensureNotNull(directory, "The directory may not be null");
        boolean bl = result = createParents ? directory.mkdirs() : directory.mkdir();
        if (!result && !directory.exists()) {
            throw new IOException("Failed to create directory \"" + directory + "\"");
        }
    }

    private FileUtil() {
    }

    public static void mkdir(@NotNull File directory) throws IOException {
        FileUtil.mkdir(directory, false);
    }

    public static void mkdirs(@NotNull File directory) throws IOException {
        FileUtil.mkdir(directory, true);
    }

    public static void delete(@NotNull File file) throws IOException {
        Condition.ensureNotNull(file, "The file may not be null");
        boolean result = file.delete();
        if (!result && file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("Directory \"" + file + "\" must be empty before being deleted");
            }
            throw new IOException("Failed to deleted file \"" + file + "\"");
        }
    }

    public static void deleteRecursively(@NotNull File file) throws IOException {
        File[] files;
        Condition.ensureNotNull(file, "The file or directory may not be null");
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File child : files) {
                FileUtil.deleteRecursively(child);
            }
        }
        FileUtil.delete(file);
    }

    public static void createNewFile(@NotNull File file) throws IOException {
        FileUtil.createNewFile(file, false);
    }

    public static void createNewFile(@NotNull File file, boolean overwrite) throws IOException {
        Condition.ensureNotNull(file, "The file may not be null");
        boolean result = file.createNewFile();
        if (!result) {
            if (overwrite) {
                try {
                    FileUtil.delete(file);
                    FileUtil.createNewFile(file, false);
                }
                catch (IOException e) {
                    throw new IOException("Failed to overwrite file \"" + file + "\"");
                }
            } else {
                if (file.exists()) {
                    throw new IOException("File \"" + file + "\" does already exist");
                }
                throw new IllegalArgumentException("The file must not be a directory");
            }
        }
    }
}

