/*
 * Decompiled with CFR 0.152.
 */
package de.mrapp.util;

import de.mrapp.util.Condition;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00042\b\b\u0002\u0010\u000b\u001a\u00020\u0004H\u0007J\"\u0010\u0007\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\b\b\u0002\u0010\u000b\u001a\u00020\u0004H\u0007J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007J\u001a\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007J\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\bJ \u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0012H\u0002J&\u0010\u0019\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\u00042\b\b\u0002\u0010\u0018\u001a\u00020\u0012H\u0007J&\u0010\u0019\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\u00042\b\b\u0002\u0010\u000b\u001a\u00020\u00042\b\b\u0002\u0010\u0018\u001a\u00020\u0012H\u0007J&\u0010\u001a\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\u00042\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0004H\u0007J.\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00042\b\b\u0002\u0010\u000b\u001a\u00020\u00042\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0004H\u0007J\u000e\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\bJ\u0018\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0012H\u0002J\u000e\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\bJ$\u0010 \u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\u00042\b\b\u0002\u0010\u0018\u001a\u00020\u0012H\u0007J$\u0010 \u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\b\b\u0002\u0010\u000b\u001a\u00020\u00042\b\b\u0002\u0010\u0018\u001a\u00020\u0012H\u0007J\"\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0010\u001a\u00020\b2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lde/mrapp/util/FileUtil;", "", "()V", "SUFFIX_SEPARATOR", "", "SUFFIX_SEPARATOR_CHAR", "", "appendSuffix", "Ljava/io/File;", "file", "suffix", "separator", "fileName", "copy", "", "source", "destination", "overwrite", "", "create", "delete", "deleteRecursively", "getStartOfSuffix", "", "firstOccurrence", "getSuffix", "getUniqueFile", "getUniqueFileName", "directory", "mkdir", "createParents", "mkdirs", "removeSuffix", "writeTo", "data", "", "JavaUtil"})
public final class FileUtil {
    @NotNull
    public static final String SUFFIX_SEPARATOR = ".";
    public static final char SUFFIX_SEPARATOR_CHAR = '.';
    public static final FileUtil INSTANCE;

    private final void mkdir(File file, boolean createParents) throws IOException {
        boolean result;
        boolean bl = result = createParents ? file.mkdirs() : file.mkdir();
        if (!result && !file.exists()) {
            throw (Throwable)new IOException("Failed to create directory \"" + file + '\"');
        }
    }

    private final int getStartOfSuffix(String fileName, String separator, boolean firstOccurrence) {
        return firstOccurrence ? StringsKt.indexOf$default((CharSequence)fileName, (String)separator, (int)0, (boolean)false, (int)6, null) : StringsKt.lastIndexOf$default((CharSequence)fileName, (String)separator, (int)0, (boolean)false, (int)6, null);
    }

    public final void mkdir(@NotNull File file) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.mkdir(file, false);
    }

    public final void mkdirs(@NotNull File file) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.mkdir(file, true);
    }

    public final void delete(@NotNull File file) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        boolean result = file.delete();
        if (!result && file.exists()) {
            if (file.isDirectory()) {
                throw (Throwable)new IOException("Failed to delete directory \"" + file + "\". Make sure that is is empty");
            }
            throw (Throwable)new IOException("Failed to deleted file \"" + file + '\"');
        }
    }

    public final void deleteRecursively(@NotNull File file) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                File[] $this$forEach$iv = fileArray;
                boolean $i$f$forEach = false;
                File[] fileArray2 = $this$forEach$iv;
                int n = fileArray2.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File it = element$iv = fileArray2[i];
                    boolean bl = false;
                    File file2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it");
                    INSTANCE.deleteRecursively(file2);
                }
            }
        }
        this.delete(file);
    }

    @JvmOverloads
    @Nullable
    public final String getSuffix(@NotNull File file, @NotNull String separator, boolean firstOccurrence) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)separator, (String)"separator");
        String string = file.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
        return this.getSuffix(string, separator, firstOccurrence);
    }

    public static /* synthetic */ String getSuffix$default(FileUtil fileUtil, File file, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string = SUFFIX_SEPARATOR;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return fileUtil.getSuffix(file, string, bl);
    }

    @JvmOverloads
    @Nullable
    public final String getSuffix(@NotNull File file, @NotNull String separator) {
        return FileUtil.getSuffix$default(this, file, separator, false, 4, null);
    }

    @JvmOverloads
    @Nullable
    public final String getSuffix(@NotNull File file) {
        return FileUtil.getSuffix$default(this, file, null, false, 6, null);
    }

    @JvmOverloads
    @Nullable
    public final String getSuffix(@NotNull String fileName, @NotNull String separator, boolean firstOccurrence) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Intrinsics.checkParameterIsNotNull((Object)separator, (String)"separator");
        int index = this.getStartOfSuffix(fileName, separator, firstOccurrence);
        if (index != -1) {
            String string2 = fileName;
            int n = index + separator.length();
            boolean bl = false;
            String string3 = string2.substring(n);
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        } else {
            string = null;
        }
        return string;
    }

    public static /* synthetic */ String getSuffix$default(FileUtil fileUtil, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = SUFFIX_SEPARATOR;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return fileUtil.getSuffix(string, string2, bl);
    }

    @JvmOverloads
    @Nullable
    public final String getSuffix(@NotNull String fileName, @NotNull String separator) {
        return FileUtil.getSuffix$default(this, fileName, separator, false, 4, null);
    }

    @JvmOverloads
    @Nullable
    public final String getSuffix(@NotNull String fileName) {
        return FileUtil.getSuffix$default(this, fileName, null, false, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final File removeSuffix(@NotNull File file, @NotNull String separator, boolean firstOccurrence) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)separator, (String)"separator");
        String string = file.getParent();
        String string2 = file.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"file.name");
        return new File(string, this.removeSuffix(string2, separator, firstOccurrence));
    }

    public static /* synthetic */ File removeSuffix$default(FileUtil fileUtil, File file, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string = SUFFIX_SEPARATOR;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return fileUtil.removeSuffix(file, string, bl);
    }

    @JvmOverloads
    @NotNull
    public final File removeSuffix(@NotNull File file, @NotNull String separator) {
        return FileUtil.removeSuffix$default(this, file, separator, false, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final File removeSuffix(@NotNull File file) {
        return FileUtil.removeSuffix$default(this, file, null, false, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final String removeSuffix(@NotNull String fileName, @NotNull String separator, boolean firstOccurrence) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Intrinsics.checkParameterIsNotNull((Object)separator, (String)"separator");
        int index = this.getStartOfSuffix(fileName, separator, firstOccurrence);
        if (index != -1) {
            String string2 = fileName;
            int n = 0;
            boolean bl = false;
            String string3 = string2.substring(n, index);
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string = fileName;
        }
        return string;
    }

    public static /* synthetic */ String removeSuffix$default(FileUtil fileUtil, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = SUFFIX_SEPARATOR;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return fileUtil.removeSuffix(string, string2, bl);
    }

    @JvmOverloads
    @NotNull
    public final String removeSuffix(@NotNull String fileName, @NotNull String separator) {
        return FileUtil.removeSuffix$default(this, fileName, separator, false, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final String removeSuffix(@NotNull String fileName) {
        return FileUtil.removeSuffix$default(this, fileName, null, false, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final File appendSuffix(@NotNull File file, @NotNull String suffix, @NotNull String separator) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)suffix, (String)"suffix");
        Intrinsics.checkParameterIsNotNull((Object)separator, (String)"separator");
        String string = file.getParent();
        String string2 = file.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"file.name");
        return new File(string, this.appendSuffix(string2, suffix, separator));
    }

    public static /* synthetic */ File appendSuffix$default(FileUtil fileUtil, File file, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = SUFFIX_SEPARATOR;
        }
        return fileUtil.appendSuffix(file, string, string2);
    }

    @JvmOverloads
    @NotNull
    public final File appendSuffix(@NotNull File file, @NotNull String suffix) {
        return FileUtil.appendSuffix$default(this, file, suffix, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final String appendSuffix(@NotNull String fileName, @NotNull String suffix, @NotNull String separator) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Intrinsics.checkParameterIsNotNull((Object)suffix, (String)"suffix");
        Intrinsics.checkParameterIsNotNull((Object)separator, (String)"separator");
        return StringsKt.endsWith$default((String)fileName, (String)separator, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)suffix, (String)separator, (boolean)false, (int)2, null) ? fileName + suffix : fileName + separator + suffix;
    }

    public static /* synthetic */ String appendSuffix$default(FileUtil fileUtil, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = SUFFIX_SEPARATOR;
        }
        return fileUtil.appendSuffix(string, string2, string3);
    }

    @JvmOverloads
    @NotNull
    public final String appendSuffix(@NotNull String fileName, @NotNull String suffix) {
        return FileUtil.appendSuffix$default(this, fileName, suffix, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final File getUniqueFile(@NotNull File file, @NotNull String separator, @Nullable String suffix) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)separator, (String)"separator");
        String string = file.getParent();
        File file2 = new File(file.getParent());
        String string2 = file.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"file.name");
        return new File(string, this.getUniqueFileName(file2, string2, separator, suffix));
    }

    public static /* synthetic */ File getUniqueFile$default(FileUtil fileUtil, File file, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string = SUFFIX_SEPARATOR;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        return fileUtil.getUniqueFile(file, string, string2);
    }

    @JvmOverloads
    @NotNull
    public final File getUniqueFile(@NotNull File file, @NotNull String separator) {
        return FileUtil.getUniqueFile$default(this, file, separator, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final File getUniqueFile(@NotNull File file) {
        return FileUtil.getUniqueFile$default(this, file, null, null, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final String getUniqueFileName(@NotNull File directory, @NotNull String fileName, @NotNull String separator, @Nullable String suffix) {
        String string;
        boolean bl;
        boolean bl2;
        String string2;
        String currentFileName;
        block14: {
            block13: {
                Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
                Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
                Intrinsics.checkParameterIsNotNull((Object)separator, (String)"separator");
                Condition.INSTANCE.ensureFileIsDirectory(directory, directory.getAbsolutePath() + " is not a directory");
                Condition.INSTANCE.ensureNotEmpty(fileName, "The file name may not be empty");
                currentFileName = fileName;
                string2 = suffix;
                if (string2 == null) break block13;
                String string3 = string2;
                boolean bl3 = false;
                bl2 = false;
                String it = string3;
                bl = false;
                string = INSTANCE.appendSuffix(currentFileName, suffix, separator);
                string2 = string;
                if (string2 != null) break block14;
            }
            string2 = currentFileName;
        }
        String currentFileNameWithSuffix = string2;
        int counter = 2;
        while (true) {
            String string4;
            block16: {
                block15: {
                    String string5;
                    block12: {
                        if (directory.list() != null) {
                            String[] stringArray;
                            bl2 = false;
                            String[] stringArray2 = stringArray;
                            bl = false;
                            String[] stringArray3 = stringArray2;
                            int n = stringArray3.length;
                            for (int i = 0; i < n; ++i) {
                                String string6;
                                String name = string6 = stringArray3[i];
                                boolean bl4 = false;
                                if (!Intrinsics.areEqual((Object)name, (Object)currentFileNameWithSuffix)) continue;
                                string5 = string6;
                                break block12;
                            }
                            string5 = null;
                        } else {
                            string5 = null;
                        }
                    }
                    if (string5 == null) break;
                    currentFileName = fileName + counter;
                    string4 = suffix;
                    if (string4 == null) break block15;
                    String string7 = string4;
                    bl2 = false;
                    boolean bl5 = false;
                    String it = string7;
                    boolean bl6 = false;
                    string = INSTANCE.appendSuffix(currentFileName, suffix, separator);
                    string4 = string;
                    if (string4 != null) break block16;
                }
                string4 = currentFileName;
            }
            currentFileNameWithSuffix = string4;
            ++counter;
        }
        return currentFileNameWithSuffix;
    }

    public static /* synthetic */ String getUniqueFileName$default(FileUtil fileUtil, File file, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = SUFFIX_SEPARATOR;
        }
        if ((n & 8) != 0) {
            string3 = null;
        }
        return fileUtil.getUniqueFileName(file, string, string2, string3);
    }

    @JvmOverloads
    @NotNull
    public final String getUniqueFileName(@NotNull File directory, @NotNull String fileName, @NotNull String separator) {
        return FileUtil.getUniqueFileName$default(this, directory, fileName, separator, null, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final String getUniqueFileName(@NotNull File directory, @NotNull String fileName) {
        return FileUtil.getUniqueFileName$default(this, directory, fileName, null, null, 12, null);
    }

    @JvmOverloads
    public final void create(@NotNull File file, boolean overwrite) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        boolean result = file.createNewFile();
        if (!result) {
            if (overwrite) {
                try {
                    this.delete(file);
                    this.create(file, false);
                }
                catch (IOException e) {
                    throw (Throwable)new IOException("Failed to overwrite file \"" + file + '\"');
                }
            } else {
                throw (Throwable)new IOException("Failed to create file \"" + file + '\"');
            }
        }
    }

    public static /* synthetic */ void create$default(FileUtil fileUtil, File file, boolean bl, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            bl = false;
        }
        fileUtil.create(file, bl);
    }

    @JvmOverloads
    public final void create(@NotNull File file) throws IOException {
        FileUtil.create$default(this, file, false, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public final void writeTo(@NotNull byte[] data, @NotNull File destination, boolean overwrite) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        this.create(destination, overwrite);
        Closeable closeable = new BufferedOutputStream(new FileOutputStream(destination));
        boolean bl = false;
        Throwable throwable = null;
        try {
            BufferedOutputStream stream = (BufferedOutputStream)closeable;
            boolean bl2 = false;
            stream.write(data);
            stream.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void writeTo$default(FileUtil fileUtil, byte[] byArray, File file, boolean bl, int n, Object object) throws IOException {
        if ((n & 4) != 0) {
            bl = false;
        }
        fileUtil.writeTo(byArray, file, bl);
    }

    @JvmOverloads
    public final void writeTo(@NotNull byte[] data, @NotNull File destination) throws IOException {
        FileUtil.writeTo$default(this, data, destination, false, 4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public final void copy(@NotNull File source, @NotNull File destination, boolean overwrite) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        Condition.INSTANCE.ensureFileIsNoDirectory(source, "The source must exist and must not be a directory");
        this.create(destination, overwrite);
        Closeable closeable = new FileInputStream(source);
        boolean bl = false;
        Throwable throwable = null;
        try {
            long l;
            FileInputStream inputStream = (FileInputStream)closeable;
            boolean bl2 = false;
            Closeable closeable2 = new FileOutputStream(destination);
            boolean bl3 = false;
            Throwable throwable2 = null;
            try {
                FileOutputStream outputStream = (FileOutputStream)closeable2;
                boolean bl4 = false;
                FileChannel inChannel = inputStream.getChannel();
                FileChannel outChannel = outputStream.getChannel();
                l = inChannel.transferTo(0L, inChannel.size(), outChannel);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void copy$default(FileUtil fileUtil, File file, File file2, boolean bl, int n, Object object) throws IOException {
        if ((n & 4) != 0) {
            bl = false;
        }
        fileUtil.copy(file, file2, bl);
    }

    @JvmOverloads
    public final void copy(@NotNull File source, @NotNull File destination) throws IOException {
        FileUtil.copy$default(this, source, destination, false, 4, null);
    }

    private FileUtil() {
    }

    static {
        FileUtil fileUtil;
        INSTANCE = fileUtil = new FileUtil();
    }
}

