/*
 * Decompiled with CFR 0.152.
 */
package tss;

import tss.Helpers;
import tss.TpmMarshaller;
import tss.TpmStructure;

public class TpmStructurePrinter {
    StringBuilder b = new StringBuilder();

    public TpmStructurePrinter() {
    }

    public TpmStructurePrinter(String typeName) {
        this.write(typeName + " =\n");
        this.write("{\n");
    }

    public String toString() {
        return this.b.toString();
    }

    public void endStruct() {
        this.write("}");
    }

    void write(String s) {
        s = s.replace("\n", System.lineSeparator());
        this.b.append(s);
    }

    void writeLine(int nesting, String data) {
        String line = data;
        line = TpmStructurePrinter.tabify(line);
        line = TpmStructurePrinter.spaces(line, nesting) + "\n";
        this.write(line);
    }

    void writeLine(int nesting, String typeName, String variableName, String value) {
        String line = typeName + " " + variableName + " = " + value;
        line = TpmStructurePrinter.tabify(line);
        line = TpmStructurePrinter.spaces(line, nesting) + "\n";
        this.write(line);
    }

    public void add(int nesting, String typeName, String variableName, Object v) {
        if (v == null) {
            return;
        }
        if (v instanceof TpmStructure) {
            TpmStructure sb = (TpmStructure)v;
            this.writeLine(nesting, typeName, variableName, "");
            this.writeLine(nesting, "{");
            sb.toStringInternal(this, nesting + 1);
            this.writeLine(nesting, "}");
            return;
        }
        if (v instanceof TpmMarshaller) {
            this.writeLine(nesting, typeName, variableName, v.toString());
            return;
        }
        if (v instanceof String) {
            this.writeLine(nesting, typeName, variableName, (String)v);
            return;
        }
        if (v instanceof Integer) {
            Integer vi = (Integer)v;
            this.writeLine(nesting, typeName, variableName, String.valueOf(vi) + " (0x" + Integer.toHexString(vi) + ")");
            return;
        }
        if (v instanceof Long) {
            Long vl = (Long)v;
            this.writeLine(nesting, typeName, variableName, String.valueOf(vl) + " (0x" + Long.toHexString(vl) + ")");
            return;
        }
        if (v instanceof Short) {
            Integer vi = ((Short)v).intValue();
            this.writeLine(nesting, typeName, variableName, String.valueOf(vi) + " (0x" + Integer.toHexString(vi) + ")");
            return;
        }
        if (v instanceof Byte) {
            Integer vi = ((Byte)v).intValue();
            this.writeLine(nesting, typeName, variableName, String.valueOf(vi) + " (0x" + Integer.toHexString(vi) + ")");
            return;
        }
        if (v instanceof byte[]) {
            this.writeLine(nesting, typeName + "[]", variableName, Helpers.toHex((byte[])v));
            return;
        }
        if (v instanceof Object[]) {
            Object[] oArr = (Object[])v;
            int len = oArr.length;
            this.add(nesting, typeName, variableName + "[" + String.valueOf(len) + "]", "");
            this.writeLine(nesting, "{");
            for (int j = 0; j < len; ++j) {
                this.add(nesting + 1, "[" + String.valueOf(j) + "]", "", oArr[j]);
            }
            this.writeLine(nesting, "}");
            return;
        }
        throw new AssertionError((Object)"Should not be here");
    }

    static String tabify(String s) {
        int pos;
        while ((pos = s.indexOf("<")) >= 0) {
            int pos2 = s.indexOf(">");
            String tabPos = s.substring(pos + 1, pos2);
            int tab = Integer.parseInt(tabPos);
            s = s.substring(0, pos) + TpmStructurePrinter.makeSpaces(tab - pos) + s.substring(pos2 + 1, s.length());
        }
        return s;
    }

    static String spaces(String line, int num) {
        String spaces = new String(new char[num * 4]).replace("\u0000", " ");
        line = spaces + line;
        line = line.replace("\n", spaces + "\n");
        return line;
    }

    static String makeSpaces(int num) {
        return new String(new char[num]).replace("\u0000", " ");
    }
}

