/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import java.util.Stack;
import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMS_ECC_POINT;

public class CommitResponse
extends TpmStructure {
    public TPMS_ECC_POINT K;
    public TPMS_ECC_POINT L;
    public TPMS_ECC_POINT E;
    public short counter;

    public CommitResponse(TPMS_ECC_POINT _K, TPMS_ECC_POINT _L, TPMS_ECC_POINT _E, int _counter) {
        this.K = _K;
        this.L = _L;
        this.E = _E;
        this.counter = (short)_counter;
    }

    public CommitResponse() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.K != null ? this.K.toTpm().length : 0, 2);
        this.K.toTpm(buf);
        buf.writeInt(this.L != null ? this.L.toTpm().length : 0, 2);
        this.L.toTpm(buf);
        buf.writeInt(this.E != null ? this.E.toTpm().length : 0, 2);
        this.E.toTpm(buf);
        buf.write(this.counter);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _KSize = buf.readInt(2);
        Stack<InByteBuf.SizedStructInfo> stack = buf.structSize;
        InByteBuf inByteBuf = buf;
        inByteBuf.getClass();
        stack.push(inByteBuf.new InByteBuf.SizedStructInfo(buf.curPos(), _KSize));
        this.K = TPMS_ECC_POINT.fromTpm(buf);
        buf.structSize.pop();
        int _LSize = buf.readInt(2);
        Stack<InByteBuf.SizedStructInfo> stack2 = buf.structSize;
        InByteBuf inByteBuf2 = buf;
        inByteBuf2.getClass();
        stack2.push(inByteBuf2.new InByteBuf.SizedStructInfo(buf.curPos(), _LSize));
        this.L = TPMS_ECC_POINT.fromTpm(buf);
        buf.structSize.pop();
        int _ESize = buf.readInt(2);
        Stack<InByteBuf.SizedStructInfo> stack3 = buf.structSize;
        InByteBuf inByteBuf3 = buf;
        inByteBuf3.getClass();
        stack3.push(inByteBuf3.new InByteBuf.SizedStructInfo(buf.curPos(), _ESize));
        this.E = TPMS_ECC_POINT.fromTpm(buf);
        buf.structSize.pop();
        this.counter = (short)buf.readInt(2);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static CommitResponse fromTpm(byte[] x) {
        CommitResponse ret = new CommitResponse();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static CommitResponse fromTpm(InByteBuf buf) {
        CommitResponse ret = new CommitResponse();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_Commit_RESPONSE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPMS_ECC_POINT", "K", this.K);
        _p.add(d, "TPMS_ECC_POINT", "L", this.L);
        _p.add(d, "TPMS_ECC_POINT", "E", this.E);
        _p.add(d, "ushort", "counter", this.counter);
    }
}

