/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;

public class FirmwareReadResponse
extends TpmStructure {
    public byte[] fuData;

    public FirmwareReadResponse(byte[] _fuData) {
        this.fuData = _fuData;
    }

    public FirmwareReadResponse() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.fuData != null ? this.fuData.length : 0, 2);
        buf.write(this.fuData);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _fuDataSize = buf.readInt(2);
        this.fuData = new byte[_fuDataSize];
        buf.readArrayOfInts(this.fuData, 1, _fuDataSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static FirmwareReadResponse fromTpm(byte[] x) {
        FirmwareReadResponse ret = new FirmwareReadResponse();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static FirmwareReadResponse fromTpm(InByteBuf buf) {
        FirmwareReadResponse ret = new FirmwareReadResponse();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_FirmwareRead_RESPONSE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "byte", "fuData", this.fuData);
    }
}

