/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import java.util.Stack;
import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPMT_PUBLIC;

public class ReadPublicResponse
extends TpmStructure {
    public TPMT_PUBLIC outPublic;
    public byte[] name;
    public byte[] qualifiedName;

    public ReadPublicResponse(TPMT_PUBLIC _outPublic, byte[] _name, byte[] _qualifiedName) {
        this.outPublic = _outPublic;
        this.name = _name;
        this.qualifiedName = _qualifiedName;
    }

    public ReadPublicResponse() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.outPublic != null ? this.outPublic.toTpm().length : 0, 2);
        this.outPublic.toTpm(buf);
        buf.writeInt(this.name != null ? this.name.length : 0, 2);
        buf.write(this.name);
        buf.writeInt(this.qualifiedName != null ? this.qualifiedName.length : 0, 2);
        buf.write(this.qualifiedName);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _outPublicSize = buf.readInt(2);
        Stack<InByteBuf.SizedStructInfo> stack = buf.structSize;
        InByteBuf inByteBuf = buf;
        inByteBuf.getClass();
        stack.push(inByteBuf.new InByteBuf.SizedStructInfo(buf.curPos(), _outPublicSize));
        this.outPublic = TPMT_PUBLIC.fromTpm(buf);
        buf.structSize.pop();
        int _nameSize = buf.readInt(2);
        this.name = new byte[_nameSize];
        buf.readArrayOfInts(this.name, 1, _nameSize);
        int _qualifiedNameSize = buf.readInt(2);
        this.qualifiedName = new byte[_qualifiedNameSize];
        buf.readArrayOfInts(this.qualifiedName, 1, _qualifiedNameSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static ReadPublicResponse fromTpm(byte[] x) {
        ReadPublicResponse ret = new ReadPublicResponse();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static ReadPublicResponse fromTpm(InByteBuf buf) {
        ReadPublicResponse ret = new ReadPublicResponse();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_ReadPublic_RESPONSE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPMT_PUBLIC", "outPublic", this.outPublic);
        _p.add(d, "byte", "name", this.name);
        _p.add(d, "byte", "qualifiedName", this.qualifiedName);
    }
}

